/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.task.installation.install.sl;

import java.io.File;
import java.util.logging.Logger;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ow2.petals.jbi.management.Context;
import org.ow2.petals.jbi.management.task.installation.install.sl.CreateSLStateHolderTask;
import org.ow2.petals.system.systemstate.SystemStateService;
import org.ow2.petals.system.systemstate.exception.ComponentAlreadyExistsException;
import org.ow2.petals.system.systemstate.exception.SharedLibraryAlreadyExistsException;
import org.ow2.petals.systemstate.generated.SharedLibrary;
import org.ow2.petals.util.AbstractMavenTest;
import org.ow2.petals.util.LoggingUtil;

public class CreateSLStateHolderTaskTest
extends AbstractMavenTest {
    private static final String SL_NAME = "mySLName";
    private static final String SL_VERSION = "1.0.0";
    private static final String ARCHIVE_FILE_NAME = "archive.zip";
    final LoggingUtil log = new LoggingUtil(Logger.getLogger(CreateSLStateHolderTaskTest.class.getName()));
    private String petalsHomeDir;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.petalsHomeDir = new File(this.targetDir, "petals-home").getAbsolutePath();
    }

    @Test
    public void testCreateSLStateHolderTask_000() throws Exception {
        SystemStateService systemStateSvc = (SystemStateService)EasyMock.createMock(SystemStateService.class);
        EasyMock.expect((Object)systemStateSvc.createSharedLibraryStateHolder(SL_NAME, SL_VERSION, this.targetDir.toURI().toURL(), ARCHIVE_FILE_NAME)).andAnswer((IAnswer)new IAnswer<SharedLibrary>(){

            public SharedLibrary answer() throws Throwable {
                SharedLibrary sharedLibrary = new SharedLibrary();
                sharedLibrary.setName(CreateSLStateHolderTaskTest.SL_NAME);
                sharedLibrary.setVersion(CreateSLStateHolderTaskTest.SL_VERSION);
                return sharedLibrary;
            }
        });
        EasyMock.replay((Object[])new Object[]{systemStateSvc});
        Context ctx = new Context();
        ctx.setEntityName(SL_NAME);
        ctx.setEntityVersion(SL_VERSION);
        ctx.setArchiveUrl(new File(this.targetDir, ARCHIVE_FILE_NAME).toURI().toURL());
        ctx.setInstallUrl(this.targetDir.toURI().toURL());
        CreateSLStateHolderTask task = new CreateSLStateHolderTask(this.log, systemStateSvc, this.petalsHomeDir);
        task.execute(ctx);
        EasyMock.verify((Object[])new Object[]{systemStateSvc});
    }

    @Test
    public void testCreateSLStateHolderTask_001() throws Exception {
        SystemStateService systemStateSvc = (SystemStateService)EasyMock.createMock(SystemStateService.class);
        EasyMock.expect((Object)systemStateSvc.createSharedLibraryStateHolder(SL_NAME, SL_VERSION, this.targetDir.toURI().toURL(), ARCHIVE_FILE_NAME)).andAnswer((IAnswer)new IAnswer<SharedLibrary>(){

            public SharedLibrary answer() throws Throwable {
                SharedLibrary sharedLibrary = new SharedLibrary();
                sharedLibrary.setName(CreateSLStateHolderTaskTest.SL_NAME);
                sharedLibrary.setVersion(CreateSLStateHolderTaskTest.SL_VERSION);
                return sharedLibrary;
            }
        });
        EasyMock.expect((Object)systemStateSvc.createSharedLibraryStateHolder(SL_NAME, SL_VERSION, this.targetDir.toURI().toURL(), ARCHIVE_FILE_NAME)).andThrow((Throwable)new SharedLibraryAlreadyExistsException(SL_NAME, SL_VERSION));
        EasyMock.replay((Object[])new Object[]{systemStateSvc});
        Context ctx1 = new Context();
        ctx1.setEntityName(SL_NAME);
        ctx1.setEntityVersion(SL_VERSION);
        ctx1.setArchiveUrl(new File(this.targetDir, ARCHIVE_FILE_NAME).toURI().toURL());
        ctx1.setInstallUrl(this.targetDir.toURI().toURL());
        CreateSLStateHolderTask task1 = new CreateSLStateHolderTask(this.log, systemStateSvc, this.petalsHomeDir);
        task1.execute(ctx1);
        try {
            Context ctx2 = new Context();
            ctx2.setEntityName(SL_NAME);
            ctx2.setEntityVersion(SL_VERSION);
            ctx2.setArchiveUrl(new File(this.targetDir, ARCHIVE_FILE_NAME).toURI().toURL());
            ctx2.setInstallUrl(this.targetDir.toURI().toURL());
            CreateSLStateHolderTask task2 = new CreateSLStateHolderTask(this.log, systemStateSvc, this.petalsHomeDir);
            task2.execute(ctx2);
            Assert.fail((String)("The exception " + ComponentAlreadyExistsException.class.getName() + " is not raised."));
        }
        catch (SharedLibraryAlreadyExistsException sharedLibraryAlreadyExistsException) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{systemStateSvc});
    }

    @Test
    public void testCreateSLStateHolderTask_002() throws Exception {
        SystemStateService systemStateSvc = (SystemStateService)EasyMock.createMock(SystemStateService.class);
        final SharedLibrary sharedLibrary = new SharedLibrary();
        sharedLibrary.setName(SL_NAME);
        sharedLibrary.setVersion(SL_VERSION);
        EasyMock.expect((Object)systemStateSvc.createSharedLibraryStateHolder(SL_NAME, SL_VERSION, this.targetDir.toURI().toURL(), ARCHIVE_FILE_NAME)).andAnswer((IAnswer)new IAnswer<SharedLibrary>(){

            public SharedLibrary answer() throws Throwable {
                return sharedLibrary;
            }
        });
        EasyMock.expect((Object)systemStateSvc.deleteSharedLibraryStateHolder(SL_NAME, SL_VERSION)).andAnswer((IAnswer)new IAnswer<SharedLibrary>(){

            public SharedLibrary answer() throws Throwable {
                return sharedLibrary;
            }
        });
        EasyMock.replay((Object[])new Object[]{systemStateSvc});
        Context ctx = new Context();
        ctx.setEntityName(SL_NAME);
        ctx.setEntityVersion(SL_VERSION);
        ctx.setArchiveUrl(new File(this.targetDir, ARCHIVE_FILE_NAME).toURI().toURL());
        ctx.setInstallUrl(this.targetDir.toURI().toURL());
        CreateSLStateHolderTask task = new CreateSLStateHolderTask(this.log, systemStateSvc, this.petalsHomeDir);
        task.execute(ctx);
        task.undo(ctx);
        EasyMock.verify((Object[])new Object[]{systemStateSvc});
    }

    @Test
    public void testCreateSLStateHolderTask_003() throws Exception {
        SystemStateService systemStateSvc = (SystemStateService)EasyMock.createMock(SystemStateService.class);
        EasyMock.expect((Object)systemStateSvc.deleteSharedLibraryStateHolder(SL_NAME, SL_VERSION)).andAnswer((IAnswer)new IAnswer<SharedLibrary>(){

            public SharedLibrary answer() throws Throwable {
                SharedLibrary sharedLibrary = new SharedLibrary();
                sharedLibrary.setName(CreateSLStateHolderTaskTest.SL_NAME);
                sharedLibrary.setVersion(CreateSLStateHolderTaskTest.SL_VERSION);
                return sharedLibrary;
            }
        });
        EasyMock.replay((Object[])new Object[]{systemStateSvc});
        Context ctx = new Context();
        ctx.setEntityName(SL_NAME);
        ctx.setEntityVersion(SL_VERSION);
        ctx.setArchiveUrl(new File(this.targetDir, ARCHIVE_FILE_NAME).toURI().toURL());
        ctx.setInstallUrl(this.targetDir.toURI().toURL());
        CreateSLStateHolderTask task = new CreateSLStateHolderTask(this.log, systemStateSvc, this.petalsHomeDir);
        task.undo(ctx);
        EasyMock.verify((Object[])new Object[]{systemStateSvc});
    }
}

