/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.task.installation.install.sl;

import java.io.FileNotFoundException;
import java.util.logging.Logger;
import org.easymock.EasyMock;
import org.junit.Test;
import org.ow2.petals.jbi.management.Context;
import org.ow2.petals.jbi.management.task.installation.uninstall.sl.RemoveSLRepositoryTask;
import org.ow2.petals.system.repository.RepositoryService;
import org.ow2.petals.util.AbstractMavenTest;
import org.ow2.petals.util.LoggingUtil;

public class RemoveSLRepositoryTaskTest
extends AbstractMavenTest {
    private static final String SL_NAME = "mySLName";
    private static final String SL_VERSION = "1.0.0";
    final LoggingUtil log = new LoggingUtil(Logger.getLogger(RemoveSLRepositoryTaskTest.class.getName()));

    @Test
    public void testRemoveSLRepositoryTask_000() throws Exception {
        RepositoryService repositorySvc = (RepositoryService)EasyMock.createMock(RepositoryService.class);
        repositorySvc.removeSharedLibrary(SL_NAME, SL_VERSION);
        EasyMock.replay((Object[])new Object[]{repositorySvc});
        Context ctx = new Context();
        ctx.setEntityName(SL_NAME);
        ctx.setEntityVersion(SL_VERSION);
        RemoveSLRepositoryTask task = new RemoveSLRepositoryTask(this.log, repositorySvc);
        task.execute(ctx);
        EasyMock.verify((Object[])new Object[]{repositorySvc});
    }

    @Test
    public void testRemoveSLRepositoryTask_001() throws Exception {
        RepositoryService repositorySvc = (RepositoryService)EasyMock.createMock(RepositoryService.class);
        repositorySvc.removeSharedLibrary(SL_NAME, SL_VERSION);
        repositorySvc.removeSharedLibrary(SL_NAME, SL_VERSION);
        EasyMock.expectLastCall().andThrow((Throwable)new FileNotFoundException());
        EasyMock.replay((Object[])new Object[]{repositorySvc});
        Context ctx1 = new Context();
        ctx1.setEntityName(SL_NAME);
        ctx1.setEntityVersion(SL_VERSION);
        RemoveSLRepositoryTask task1 = new RemoveSLRepositoryTask(this.log, repositorySvc);
        task1.execute(ctx1);
        Context ctx2 = new Context();
        ctx2.setEntityName(SL_NAME);
        ctx2.setEntityVersion(SL_VERSION);
        RemoveSLRepositoryTask task2 = new RemoveSLRepositoryTask(this.log, repositorySvc);
        task2.execute(ctx2);
        EasyMock.verify((Object[])new Object[]{repositorySvc});
    }
}

