/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.messaging.exchange;

import java.net.URI;
import java.util.logging.Logger;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOptionalOut;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.RobustInOnly;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Test;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfOperation;
import org.ow2.petals.jbi.messaging.exchange.PersistedContextualMessageExchangeFactoryImpl;
import org.ow2.petals.jbi.messaging.exchange.PersistedContextualMessageExchangeFactoryImplTest;

public class PersistedExchangeFactoryForInterfaceImplTest
extends PersistedContextualMessageExchangeFactoryImplTest {
    private QName targetInterface = new QName("targetInterface");

    @Override
    protected MessageExchangeFactory createTestMessageExchangeFactory() {
        return PersistedContextualMessageExchangeFactoryImpl.createContextualMessageExchangeFactoryForInterface((ServiceEndpoint)this.consumerEndpointMock, (Logger)this.logger, (QName)this.targetInterface);
    }

    @Test
    public void testCreateExchangeFromServAndOpUseFactorySpecificTargetInterface() throws MessagingException {
        QName serviceName = new QName("targetService");
        QName opName = new QName("targetOperation");
        MessageExchange actualMessageExchange = this.messageExchangeFactory.createExchange(serviceName, opName);
        this.assertGeneratedExchangeUseFactorySpecificTargetInterface(actualMessageExchange);
    }

    @Test
    public void testCreateExchangeFromJBIPatternUseFactorySpecificTargetInterface() throws MessagingException {
        URI pattern = AbsItfOperation.MEPPatternConstants.IN_ONLY.value();
        MessageExchange actualMessageExchange = this.messageExchangeFactory.createExchange(pattern);
        this.assertGeneratedExchangeUseFactorySpecificTargetInterface(actualMessageExchange);
    }

    @Test
    public void testCreateInOnlyExchangeUseFactorySpecificTargetInterface() throws MessagingException {
        InOnly actualMessageExchange = this.messageExchangeFactory.createInOnlyExchange();
        this.assertGeneratedExchangeUseFactorySpecificTargetInterface((MessageExchange)actualMessageExchange);
    }

    @Test
    public void testCreateInOptionalOutExchangeUseFactorySpecificTargetInterface() throws MessagingException {
        InOptionalOut actualMessageExchange = this.messageExchangeFactory.createInOptionalOutExchange();
        this.assertGeneratedExchangeUseFactorySpecificTargetInterface((MessageExchange)actualMessageExchange);
    }

    @Test
    public void testCreateInOutExchangeUseFactorySpecificTargetInterface() throws MessagingException {
        InOut actualMessageExchange = this.messageExchangeFactory.createInOutExchange();
        this.assertGeneratedExchangeUseFactorySpecificTargetInterface((MessageExchange)actualMessageExchange);
    }

    @Test
    public void testCreateRobustInOnlyExchangeUseFactorySpecificTargetInterface() throws MessagingException {
        RobustInOnly actualMessageExchange = this.messageExchangeFactory.createRobustInOnlyExchange();
        this.assertGeneratedExchangeUseFactorySpecificTargetInterface((MessageExchange)actualMessageExchange);
    }

    private void assertGeneratedExchangeUseFactorySpecificTargetInterface(MessageExchange actualMessageExchange) {
        Assert.assertEquals((String)"Returned exchange must target factory specific interface", (Object)this.targetInterface, (Object)actualMessageExchange.getInterfaceName());
    }
}

