/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.kernel.server;

import java.util.ArrayList;
import org.easymock.classextension.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalContentException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.api.control.NameController;
import org.ow2.petals.kernel.server.Binding;
import org.ow2.petals.kernel.server.FractalHelper;

public class FractalHelperTest {
    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void testGetComponentByName() throws NoSuchInterfaceException {
        ContentController contentController = (ContentController)EasyMock.createMock(ContentController.class);
        ContentController subContentController = (ContentController)EasyMock.createMock(ContentController.class);
        Component component = (Component)EasyMock.createMock(Component.class);
        NameController nameController = (NameController)EasyMock.createMock(NameController.class);
        Component[] compos = new Component[]{component};
        Component[] subcompos = new Component[]{};
        org.easymock.EasyMock.expect((Object)contentController.getFcSubComponents()).andReturn((Object)compos);
        org.easymock.EasyMock.expect((Object)component.getFcInterface("content-controller")).andReturn((Object)subContentController);
        org.easymock.EasyMock.expect((Object)subContentController.getFcSubComponents()).andReturn((Object)subcompos);
        org.easymock.EasyMock.expect((Object)component.getFcInterface("name-controller")).andReturn((Object)nameController);
        org.easymock.EasyMock.expect((Object)nameController.getFcName()).andReturn((Object)"test");
        EasyMock.replay((Object)contentController);
        EasyMock.replay((Object)subContentController);
        EasyMock.replay((Object)component);
        EasyMock.replay((Object)nameController);
        Assert.assertEquals((Object)component, (Object)FractalHelper.getRecursiveComponentByName((ContentController)contentController, (String)"test"));
        EasyMock.verify((Object)contentController);
        EasyMock.verify((Object)subContentController);
        EasyMock.verify((Object)component);
        EasyMock.verify((Object)nameController);
    }

    @Test
    public void testGetComponentByNameException() throws NoSuchInterfaceException {
        ContentController contentController = (ContentController)EasyMock.createMock(ContentController.class);
        ContentController subContentController = (ContentController)EasyMock.createMock(ContentController.class);
        Component component = (Component)EasyMock.createMock(Component.class);
        Component[] compos = new Component[]{component};
        Component[] subcompos = new Component[]{};
        org.easymock.EasyMock.expect((Object)contentController.getFcSubComponents()).andReturn((Object)compos);
        org.easymock.EasyMock.expect((Object)component.getFcInterface("content-controller")).andReturn((Object)subContentController);
        org.easymock.EasyMock.expect((Object)subContentController.getFcSubComponents()).andReturn((Object)subcompos);
        org.easymock.EasyMock.expect((Object)component.getFcInterface("name-controller")).andThrow((Throwable)new NoSuchInterfaceException("name-controller"));
        EasyMock.replay((Object)contentController);
        EasyMock.replay((Object)subContentController);
        EasyMock.replay((Object)component);
        Assert.assertNull((Object)FractalHelper.getRecursiveComponentByName((ContentController)contentController, (String)"test"));
        EasyMock.verify((Object)contentController);
        EasyMock.verify((Object)subContentController);
        EasyMock.verify((Object)component);
    }

    @Test
    public void testGetLifeCycleControllerByName() throws NoSuchInterfaceException {
        ContentController contentController = (ContentController)EasyMock.createMock(ContentController.class);
        ContentController subContentController = (ContentController)EasyMock.createMock(ContentController.class);
        Component component = (Component)EasyMock.createMock(Component.class);
        NameController nameController = (NameController)EasyMock.createMock(NameController.class);
        LifeCycleController lifeCycleController = (LifeCycleController)EasyMock.createMock(LifeCycleController.class);
        Component[] compos = new Component[]{component};
        Component[] subcompos = new Component[]{};
        org.easymock.EasyMock.expect((Object)contentController.getFcSubComponents()).andReturn((Object)compos);
        org.easymock.EasyMock.expect((Object)component.getFcInterface("content-controller")).andReturn((Object)subContentController);
        org.easymock.EasyMock.expect((Object)subContentController.getFcSubComponents()).andReturn((Object)subcompos);
        org.easymock.EasyMock.expect((Object)component.getFcInterface("name-controller")).andReturn((Object)nameController);
        org.easymock.EasyMock.expect((Object)nameController.getFcName()).andReturn((Object)"test");
        org.easymock.EasyMock.expect((Object)component.getFcInterface("lifecycle-controller")).andReturn((Object)lifeCycleController);
        EasyMock.replay((Object)contentController);
        EasyMock.replay((Object)subContentController);
        EasyMock.replay((Object)component);
        EasyMock.replay((Object)nameController);
        EasyMock.replay((Object)lifeCycleController);
        Assert.assertEquals((Object)lifeCycleController, (Object)FractalHelper.getLifeCycleControllerByName((ContentController)contentController, (String)"test"));
        EasyMock.verify((Object)contentController);
        EasyMock.verify((Object)subContentController);
        EasyMock.verify((Object)component);
        EasyMock.verify((Object)nameController);
        EasyMock.verify((Object)lifeCycleController);
        EasyMock.reset((Object)contentController);
        EasyMock.reset((Object)subContentController);
        EasyMock.reset((Object)component);
        EasyMock.reset((Object)nameController);
        EasyMock.reset((Object)lifeCycleController);
        org.easymock.EasyMock.expect((Object)contentController.getFcSubComponents()).andReturn((Object)compos);
        org.easymock.EasyMock.expect((Object)component.getFcInterface("content-controller")).andReturn((Object)subContentController);
        org.easymock.EasyMock.expect((Object)subContentController.getFcSubComponents()).andReturn((Object)subcompos);
        org.easymock.EasyMock.expect((Object)component.getFcInterface("name-controller")).andReturn((Object)nameController);
        org.easymock.EasyMock.expect((Object)nameController.getFcName()).andReturn((Object)"test");
        EasyMock.replay((Object)contentController);
        EasyMock.replay((Object)subContentController);
        EasyMock.replay((Object)component);
        EasyMock.replay((Object)nameController);
        EasyMock.replay((Object)lifeCycleController);
        Assert.assertEquals(null, (Object)FractalHelper.getLifeCycleControllerByName((ContentController)contentController, null));
        EasyMock.verify((Object)contentController);
        EasyMock.verify((Object)subContentController);
        EasyMock.verify((Object)component);
        EasyMock.verify((Object)nameController);
        EasyMock.verify((Object)lifeCycleController);
    }

    @Test
    public void testStartComponent() throws NoSuchInterfaceException, IllegalLifeCycleException {
        LifeCycleController lifeCycleController = (LifeCycleController)EasyMock.createMock(LifeCycleController.class);
        Component component = (Component)EasyMock.createMock(Component.class);
        org.easymock.EasyMock.expect((Object)component.getFcInterface("lifecycle-controller")).andReturn((Object)lifeCycleController);
        org.easymock.EasyMock.expect((Object)lifeCycleController.getFcState()).andReturn((Object)"STOPPED");
        lifeCycleController.startFc();
        EasyMock.replay((Object)component);
        EasyMock.replay((Object)lifeCycleController);
        Assert.assertTrue((boolean)FractalHelper.startComponent((Component)component));
        EasyMock.verify((Object)component);
        EasyMock.verify((Object)lifeCycleController);
        EasyMock.reset((Object)component);
        EasyMock.reset((Object)lifeCycleController);
        org.easymock.EasyMock.expect((Object)component.getFcInterface("lifecycle-controller")).andReturn((Object)lifeCycleController);
        org.easymock.EasyMock.expect((Object)lifeCycleController.getFcState()).andReturn((Object)"STARTED");
        EasyMock.replay((Object)component);
        EasyMock.replay((Object)lifeCycleController);
        Assert.assertFalse((boolean)FractalHelper.startComponent((Component)component));
        EasyMock.verify((Object)component);
    }

    @Test
    public void testStopComponent() throws NoSuchInterfaceException, IllegalLifeCycleException {
        LifeCycleController lifeCycleController = (LifeCycleController)EasyMock.createMock(LifeCycleController.class);
        Component component = (Component)EasyMock.createMock(Component.class);
        org.easymock.EasyMock.expect((Object)component.getFcInterface("lifecycle-controller")).andReturn((Object)lifeCycleController);
        org.easymock.EasyMock.expect((Object)lifeCycleController.getFcState()).andReturn((Object)"STARTED");
        lifeCycleController.stopFc();
        EasyMock.replay((Object)component);
        EasyMock.replay((Object)lifeCycleController);
        Assert.assertTrue((boolean)FractalHelper.stopComponent((Component)component));
        EasyMock.verify((Object)component);
        EasyMock.verify((Object)lifeCycleController);
        EasyMock.reset((Object)component);
        EasyMock.reset((Object)lifeCycleController);
        org.easymock.EasyMock.expect((Object)component.getFcInterface("lifecycle-controller")).andReturn((Object)lifeCycleController);
        org.easymock.EasyMock.expect((Object)lifeCycleController.getFcState()).andReturn((Object)"STOPPED");
        EasyMock.replay((Object)component);
        EasyMock.replay((Object)lifeCycleController);
        Assert.assertFalse((boolean)FractalHelper.stopComponent((Component)component));
        EasyMock.verify((Object)component);
        EasyMock.verify((Object)lifeCycleController);
    }

    @Test
    public void testAddComponent() throws NoSuchInterfaceException, IllegalContentException, IllegalLifeCycleException, IllegalBindingException, ADLException {
        ContentController contentController = (ContentController)EasyMock.createMock(ContentController.class);
        Component newComponent = (Component)EasyMock.createMock(Component.class);
        Component parentComponent = (Component)EasyMock.createMock(Component.class);
        BindingController bindingController = (BindingController)EasyMock.createMock(BindingController.class);
        Binding binding = (Binding)EasyMock.createMock(Binding.class);
        Interface serverInterface = (Interface)EasyMock.createMock(Interface.class);
        ArrayList<Binding> listOfBindings = new ArrayList<Binding>();
        listOfBindings.add(binding);
        org.easymock.EasyMock.expect((Object)parentComponent.getFcInterface("content-controller")).andReturn((Object)contentController);
        contentController.addFcSubComponent(newComponent);
        org.easymock.EasyMock.expect((Object)newComponent.getFcInterface("binding-controller")).andReturn((Object)bindingController);
        org.easymock.EasyMock.expect((Object)binding.getClientInterfaceName()).andReturn((Object)"clientInterface");
        org.easymock.EasyMock.expect((Object)binding.getServerInterface()).andReturn((Object)serverInterface);
        bindingController.bindFc("clientInterface", (Object)serverInterface);
        EasyMock.replay((Object)contentController);
        EasyMock.replay((Object)newComponent);
        EasyMock.replay((Object)parentComponent);
        EasyMock.replay((Object)bindingController);
        EasyMock.replay((Object)binding);
        EasyMock.replay((Object)serverInterface);
        FractalHelper.addComponent((Component)newComponent, (Component)parentComponent, listOfBindings);
        EasyMock.verify((Object)contentController);
        EasyMock.verify((Object)newComponent);
        EasyMock.verify((Object)parentComponent);
        EasyMock.verify((Object)bindingController);
        EasyMock.verify((Object)binding);
        EasyMock.verify((Object)serverInterface);
    }
}

