/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.system.classloader.locator;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ow2.petals.system.classloader.locator.DirLocator;

public class DirLocatorTest {
    private String baseDir;

    @Before
    public void setUp() {
        this.baseDir = this.getClass().getResource(".").toString();
        this.baseDir = this.baseDir.substring(0, this.baseDir.indexOf("target"));
        this.baseDir = this.baseDir.substring(this.baseDir.indexOf(":") + 1);
    }

    @Test
    public void testHasFile() throws MalformedURLException, IOException {
        DirLocator dirLocator = new DirLocator(new URL("file:" + this.baseDir.replace(File.separator, "/") + "src/test/resources/"));
        Assert.assertTrue((boolean)dirLocator.hasFile("resourceCore.txt"));
    }

    @Test
    public void testListContent() throws MalformedURLException, IOException {
        DirLocator dirLocator = new DirLocator(new URL("file:" + this.baseDir.replace(File.separator, "/") + "src/test/resources/"));
        Assert.assertTrue((dirLocator.listContent(".").size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testExceptionNotExist() {
        try {
            new DirLocator(new URL("file:\\test%20bad_file"));
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testExceptionNotDirectory() {
        try {
            new DirLocator(new URL("file:" + this.baseDir.replace(File.separator, "/") + "src/test/resources/test.zip"));
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

