/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.system.classloader.locator;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ow2.petals.system.classloader.locator.JarFileLocator;

public class JarFileLocatorTest {
    private String baseDir;

    @Before
    public void setUp() {
        this.baseDir = this.getClass().getResource(".").toString();
        this.baseDir = this.baseDir.substring(0, this.baseDir.indexOf("target"));
        this.baseDir = this.baseDir.substring(this.baseDir.indexOf(":") + 1);
    }

    @Test
    public void testHasFile() throws MalformedURLException, IOException, URISyntaxException {
        JarFileLocator jarFileLocator = new JarFileLocator(new URI("file:" + this.baseDir.replace(File.separator, "/") + "src/test/resources/petals-core-test.jar").normalize().toURL());
        Assert.assertTrue((boolean)jarFileLocator.hasFile("META-INF/MANIFEST.MF"));
    }

    @Test
    public void testHasDirectory() throws MalformedURLException, IOException, URISyntaxException {
        JarFileLocator jarFileLocator = new JarFileLocator(new URI("file:" + this.baseDir.replace(File.separator, "/") + "src/test/resources/petals-core-test.jar").normalize().toURL());
        Assert.assertTrue((boolean)jarFileLocator.hasDirectory("META-INF"));
    }

    @Test
    public void testListContent() throws MalformedURLException, IOException, URISyntaxException {
        JarFileLocator jarFileLocator = new JarFileLocator(new URI("file:" + this.baseDir.replace(File.separator, "/") + "src/test/resources/petals-core-test.jar").normalize().toURL());
        Assert.assertTrue((jarFileLocator.listContent("META-INF").size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testHasDirectoryFalse() throws MalformedURLException, IOException, URISyntaxException {
        JarFileLocator jarFileLocator = new JarFileLocator(new URI("file:" + this.baseDir.replace(File.separator, "/") + "src/test/resources/petals-core-test.jar").normalize().toURL());
        Assert.assertFalse((boolean)jarFileLocator.hasDirectory("foo"));
    }
}

