/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.system.repository;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import org.apache.commons.io.FileUtils;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.kernel.configuration.ContainerConfiguration;
import org.ow2.petals.system.repository.RepositoryService;
import org.ow2.petals.system.repository.RepositoryServiceImpl;
import org.ow2.petals.system.repository.exception.ComponentAlreadyExistsException;
import org.ow2.petals.system.repository.exception.ServiceAssemblyAlreadyExistsException;
import org.ow2.petals.system.repository.exception.SharedLibraryAlreadyExistsException;
import org.ow2.petals.testutil.PrivateAccessor;
import org.ow2.petals.util.AbstractMavenTest;

public class RepositoryServiceImplTest
extends AbstractMavenTest {
    private static final String COMPONENT_NAME = "petals-se-helloworld";
    private static final String SA_NAME = "petals-se-helloworld";
    private static final String SL_NAME = "petals-se-helloworld";
    private static final String SL_VERSION = "1.0.0";
    private static final String REPOSITORY_DIRNAME = "repository";
    private File archiveSourceDir;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.archiveSourceDir = new File(this.testResourcesDir, "repository-service");
    }

    private RepositoryService createRepositoryService(final String repositoryDirectory) throws Exception {
        ConfigurationService configurationServiceMock = (ConfigurationService)EasyMock.createMock(ConfigurationService.class);
        EasyMock.expect((Object)configurationServiceMock.getContainerConfiguration()).andAnswer((IAnswer)new IAnswer<ContainerConfiguration>(){

            public ContainerConfiguration answer() throws Throwable {
                ContainerConfiguration contCfg = new ContainerConfiguration();
                contCfg.setRepositoryDirectoryPath(repositoryDirectory);
                return contCfg;
            }
        });
        EasyMock.replay((Object[])new Object[]{configurationServiceMock});
        RepositoryServiceImpl repositorySvc = new RepositoryServiceImpl();
        PrivateAccessor.setPrivateField(repositorySvc, "configurationService", configurationServiceMock);
        Method methodStart = repositorySvc.getClass().getDeclaredMethod("start", new Class[0]);
        methodStart.setAccessible(true);
        methodStart.invoke((Object)repositorySvc, new Object[0]);
        return repositorySvc;
    }

    @Test
    public void testAddComponent_000() throws Exception {
        File testHomeDir = new File(this.targetDir, "testAddComponent_000");
        if (testHomeDir.exists()) {
            try {
                FileUtils.deleteDirectory((File)testHomeDir);
            }
            catch (IOException e) {
                Assert.fail((String)"Unable to clean previous test execution.");
            }
        }
        File repositoryHomeDir = new File(testHomeDir, REPOSITORY_DIRNAME);
        Assert.assertTrue((boolean)repositoryHomeDir.mkdirs());
        RepositoryService repositorySvc = this.createRepositoryService(repositoryHomeDir.getAbsolutePath());
        File componentDir = new File(testHomeDir, "component");
        FileUtils.copyDirectory((File)new File(this.archiveSourceDir, "petals-se-helloworld"), (File)componentDir);
        try {
            File installationRoot = repositorySvc.addComponent("petals-se-helloworld", componentDir);
            RepositoryServiceImplTest.assertComponentInstallationRoot(installationRoot, repositoryHomeDir);
        }
        catch (ComponentAlreadyExistsException e) {
            Assert.fail((String)("Unexpected exception: " + ((Object)((Object)e)).getClass().getName()));
        }
        catch (IOException e) {
            Assert.fail((String)("Unexpected exception: " + e.getClass().getName()));
        }
    }

    private static void assertComponentInstallationRoot(File installationRoot, File repositoryHomeDir) {
        Assert.assertNotNull((Object)installationRoot);
        Assert.assertTrue((boolean)installationRoot.exists());
        Assert.assertTrue((boolean)installationRoot.getAbsolutePath().startsWith(repositoryHomeDir.getAbsolutePath()));
        Assert.assertTrue((boolean)installationRoot.getAbsolutePath().endsWith("install"));
        Assert.assertTrue((boolean)new File(installationRoot.getParentFile(), "work").exists());
        Assert.assertTrue((boolean)new File(installationRoot, "META-INF").exists());
        Assert.assertTrue((boolean)new File(new File(installationRoot, "META-INF"), "jbi.xml").exists());
        Assert.assertTrue((boolean)new File(installationRoot, "petals-se-helloworld.jar").exists());
        Assert.assertTrue((boolean)installationRoot.getParentFile().getParent().endsWith("components"));
    }

    @Test
    public void testAddComponent_001() throws Exception {
        File testHomeDir = new File(this.targetDir, "testAddComponent_001");
        if (testHomeDir.exists()) {
            try {
                FileUtils.deleteDirectory((File)testHomeDir);
            }
            catch (IOException e) {
                Assert.fail((String)"Unable to clean previous test execution.");
            }
        }
        File repositoryHomeDir = new File(testHomeDir, REPOSITORY_DIRNAME);
        Assert.assertTrue((boolean)repositoryHomeDir.mkdirs());
        RepositoryService repositorySvc = this.createRepositoryService(repositoryHomeDir.getAbsolutePath());
        File componentDir = new File(testHomeDir, "component");
        try {
            FileUtils.copyDirectory((File)new File(this.archiveSourceDir, "petals-se-helloworld"), (File)componentDir);
            File installationRoot = repositorySvc.addComponent("petals-se-helloworld", componentDir);
            RepositoryServiceImplTest.assertComponentInstallationRoot(installationRoot, repositoryHomeDir);
        }
        catch (ComponentAlreadyExistsException e) {
            Assert.fail((String)("Unexpected exception: " + ((Object)((Object)e)).getClass().getName()));
        }
        catch (IOException e) {
            Assert.fail((String)("Unexpected exception: " + e.getClass().getName()));
        }
        try {
            FileUtils.copyDirectory((File)new File(this.archiveSourceDir, "petals-se-helloworld"), (File)componentDir);
            repositorySvc.addComponent("petals-se-helloworld", componentDir);
            Assert.fail((String)("The exception " + ComponentAlreadyExistsException.class.getName() + " is not raised"));
        }
        catch (ComponentAlreadyExistsException e) {
            Assert.assertEquals((Object)"petals-se-helloworld", (Object)e.getComponentName());
            Assert.assertTrue((boolean)e.getMessage().contains("petals-se-helloworld"));
        }
        catch (IOException e) {
            Assert.fail((String)("Unexpected exception: " + e.getClass().getName()));
        }
    }

    @Test
    public void testAddComponent_003() throws Exception {
        File testHomeDir = new File(this.targetDir, "testAddComponent_003");
        if (testHomeDir.exists()) {
            try {
                FileUtils.deleteDirectory((File)testHomeDir);
            }
            catch (IOException e) {
                Assert.fail((String)"Unable to clean previous test execution.");
            }
        }
        File repositoryHomeDir = new File(testHomeDir, REPOSITORY_DIRNAME);
        Assert.assertTrue((boolean)repositoryHomeDir.mkdirs());
        RepositoryService repositorySvc = this.createRepositoryService(repositoryHomeDir.getAbsolutePath());
        File componentDir = new File(testHomeDir, "component");
        FileUtils.copyDirectory((File)new File(this.archiveSourceDir, "petals-se-helloworld"), (File)componentDir);
        try {
            FileUtils.deleteDirectory((File)repositoryHomeDir);
        }
        catch (IOException e) {
            Assert.fail((String)"Unbale to delete the repository folder.");
        }
        try {
            repositorySvc.addComponent("petals-se-helloworld", componentDir);
            Assert.fail((String)("The exception " + IOException.class.getName() + " is not raised"));
        }
        catch (ComponentAlreadyExistsException e) {
            Assert.fail((String)("Unexpected exception: " + ((Object)((Object)e)).getClass().getName()));
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains(repositoryHomeDir.getAbsolutePath()));
        }
    }

    @Test
    public void testAddSharedLibrary_000() throws Exception {
        File testHomeDir = new File(this.targetDir, "testAddSharedLibrary_000");
        if (testHomeDir.exists()) {
            try {
                FileUtils.deleteDirectory((File)testHomeDir);
            }
            catch (IOException e) {
                Assert.fail((String)"Unable to clean previous test execution.");
            }
        }
        File repositoryHomeDir = new File(testHomeDir, REPOSITORY_DIRNAME);
        Assert.assertTrue((boolean)repositoryHomeDir.mkdirs());
        RepositoryService repositorySvc = this.createRepositoryService(repositoryHomeDir.getAbsolutePath());
        File slDir = new File(testHomeDir, "sl");
        FileUtils.copyDirectory((File)new File(this.archiveSourceDir, "petals-se-helloworld"), (File)slDir);
        try {
            File installationRoot = repositorySvc.addSharedLibrary("petals-se-helloworld", SL_VERSION, slDir);
            RepositoryServiceImplTest.assertSharedLibraryInstallationRoot(installationRoot, repositoryHomeDir);
        }
        catch (SharedLibraryAlreadyExistsException e) {
            Assert.fail((String)("Unexpected exception: " + ((Object)((Object)e)).getClass().getName()));
        }
        catch (IOException e) {
            Assert.fail((String)("Unexpected exception: " + e.getClass().getName()));
        }
    }

    private static void assertSharedLibraryInstallationRoot(File installationRoot, File repositoryHomeDir) {
        Assert.assertNotNull((Object)installationRoot);
        Assert.assertTrue((boolean)installationRoot.exists());
        Assert.assertTrue((boolean)installationRoot.getAbsolutePath().startsWith(repositoryHomeDir.getAbsolutePath()));
        Assert.assertTrue((boolean)installationRoot.getAbsolutePath().endsWith("install"));
        Assert.assertTrue((boolean)new File(installationRoot.getParentFile(), "work").exists());
        Assert.assertTrue((boolean)new File(installationRoot, "META-INF").exists());
        Assert.assertTrue((boolean)new File(new File(installationRoot, "META-INF"), "jbi.xml").exists());
        Assert.assertTrue((boolean)new File(installationRoot, "petals-se-helloworld.jar").exists());
        Assert.assertTrue((boolean)installationRoot.getParentFile().getParent().endsWith("shared-libraries"));
    }

    @Test
    public void testAddSharedLibrary_001() throws Exception {
        File testHomeDir = new File(this.targetDir, "testAddSharedLibrary_001");
        if (testHomeDir.exists()) {
            try {
                FileUtils.deleteDirectory((File)testHomeDir);
            }
            catch (IOException e) {
                Assert.fail((String)"Unable to clean previous test execution.");
            }
        }
        File repositoryHomeDir = new File(testHomeDir, REPOSITORY_DIRNAME);
        Assert.assertTrue((boolean)repositoryHomeDir.mkdirs());
        RepositoryService repositorySvc = this.createRepositoryService(repositoryHomeDir.getAbsolutePath());
        File slDir = new File(testHomeDir, "sl");
        try {
            FileUtils.copyDirectory((File)new File(this.archiveSourceDir, "petals-se-helloworld"), (File)slDir);
            File installationRoot = repositorySvc.addSharedLibrary("petals-se-helloworld", SL_VERSION, slDir);
            RepositoryServiceImplTest.assertSharedLibraryInstallationRoot(installationRoot, repositoryHomeDir);
        }
        catch (SharedLibraryAlreadyExistsException e) {
            Assert.fail((String)("Unexpected exception: " + ((Object)((Object)e)).getClass().getName()));
        }
        catch (IOException e) {
            Assert.fail((String)("Unexpected exception: " + e.getClass().getName()));
        }
        try {
            FileUtils.copyDirectory((File)new File(this.archiveSourceDir, "petals-se-helloworld"), (File)slDir);
            repositorySvc.addSharedLibrary("petals-se-helloworld", SL_VERSION, slDir);
            Assert.fail((String)("The exception " + SharedLibraryAlreadyExistsException.class.getName() + " is not raised"));
        }
        catch (SharedLibraryAlreadyExistsException e) {
            Assert.assertEquals((Object)"petals-se-helloworld", (Object)e.getSharedLibraryName());
            Assert.assertEquals((Object)SL_VERSION, (Object)e.getVersion());
            Assert.assertTrue((boolean)e.getMessage().contains("petals-se-helloworld"));
            Assert.assertTrue((boolean)e.getMessage().contains(SL_VERSION));
        }
        catch (IOException e) {
            Assert.fail((String)("Unexpected exception: " + e.getClass().getName()));
        }
    }

    @Test
    public void testAddSharedLibrary_003() throws Exception {
        File testHomeDir = new File(this.targetDir, "testAddSharedLibrary_003");
        if (testHomeDir.exists()) {
            try {
                FileUtils.deleteDirectory((File)testHomeDir);
            }
            catch (IOException e) {
                Assert.fail((String)"Unable to clean previous test execution.");
            }
        }
        File repositoryHomeDir = new File(testHomeDir, REPOSITORY_DIRNAME);
        Assert.assertTrue((boolean)repositoryHomeDir.mkdirs());
        RepositoryService repositorySvc = this.createRepositoryService(repositoryHomeDir.getAbsolutePath());
        File slDir = new File(testHomeDir, "sl");
        FileUtils.copyDirectory((File)new File(this.archiveSourceDir, "petals-se-helloworld"), (File)slDir);
        try {
            FileUtils.deleteDirectory((File)repositoryHomeDir);
        }
        catch (IOException e) {
            Assert.fail((String)"Unbale to delete the repository folder.");
        }
        try {
            repositorySvc.addSharedLibrary("petals-se-helloworld", SL_VERSION, slDir);
            Assert.fail((String)("The exception " + IOException.class.getName() + " is not raised"));
        }
        catch (SharedLibraryAlreadyExistsException e) {
            Assert.fail((String)("Unexpected exception: " + ((Object)((Object)e)).getClass().getName()));
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains(repositoryHomeDir.getAbsolutePath()));
        }
    }

    @Test
    public void testAddServiceAssembly_000() throws Exception {
        File testHomeDir = new File(this.targetDir, "testAddServiceAssembly_000");
        if (testHomeDir.exists()) {
            try {
                FileUtils.deleteDirectory((File)testHomeDir);
            }
            catch (IOException e) {
                Assert.fail((String)"Unable to clean previous test execution.");
            }
        }
        File repositoryHomeDir = new File(testHomeDir, REPOSITORY_DIRNAME);
        Assert.assertTrue((boolean)repositoryHomeDir.mkdirs());
        RepositoryService repositorySvc = this.createRepositoryService(repositoryHomeDir.getAbsolutePath());
        File saDir = new File(testHomeDir, "sa");
        FileUtils.copyDirectory((File)new File(this.archiveSourceDir, "petals-se-helloworld"), (File)saDir);
        try {
            File installationRoot = repositorySvc.addServiceAssembly("petals-se-helloworld", saDir);
            RepositoryServiceImplTest.assertServiceAssemblyInstallationRoot(installationRoot, repositoryHomeDir);
        }
        catch (ServiceAssemblyAlreadyExistsException e) {
            Assert.fail((String)("Unexpected exception: " + ((Object)((Object)e)).getClass().getName()));
        }
        catch (IOException e) {
            Assert.fail((String)("Unexpected exception: " + e.getClass().getName()));
        }
    }

    private static void assertServiceAssemblyInstallationRoot(File installationRoot, File repositoryHomeDir) {
        Assert.assertNotNull((Object)installationRoot);
        Assert.assertTrue((boolean)installationRoot.exists());
        Assert.assertTrue((boolean)installationRoot.getAbsolutePath().startsWith(repositoryHomeDir.getAbsolutePath()));
        Assert.assertTrue((boolean)installationRoot.getAbsolutePath().endsWith("install"));
        Assert.assertTrue((boolean)new File(installationRoot.getParentFile(), "work").exists());
        Assert.assertTrue((boolean)new File(installationRoot, "META-INF").exists());
        Assert.assertTrue((boolean)new File(new File(installationRoot, "META-INF"), "jbi.xml").exists());
        Assert.assertTrue((boolean)new File(installationRoot, "petals-se-helloworld.jar").exists());
        Assert.assertTrue((boolean)installationRoot.getParentFile().getParent().endsWith("service-assemblies"));
    }

    @Test
    public void testAddServiceAssembly_001() throws Exception {
        File testHomeDir = new File(this.targetDir, "testAddServiceAssembly_001");
        if (testHomeDir.exists()) {
            try {
                FileUtils.deleteDirectory((File)testHomeDir);
            }
            catch (IOException e) {
                Assert.fail((String)"Unable to clean previous test execution.");
            }
        }
        File repositoryHomeDir = new File(testHomeDir, REPOSITORY_DIRNAME);
        Assert.assertTrue((boolean)repositoryHomeDir.mkdirs());
        RepositoryService repositorySvc = this.createRepositoryService(repositoryHomeDir.getAbsolutePath());
        File saDir = new File(testHomeDir, "sa");
        try {
            FileUtils.copyDirectory((File)new File(this.archiveSourceDir, "petals-se-helloworld"), (File)saDir);
            File installationRoot = repositorySvc.addServiceAssembly("petals-se-helloworld", saDir);
            RepositoryServiceImplTest.assertServiceAssemblyInstallationRoot(installationRoot, repositoryHomeDir);
        }
        catch (ServiceAssemblyAlreadyExistsException e) {
            Assert.fail((String)("Unexpected exception: " + ((Object)((Object)e)).getClass().getName()));
        }
        catch (IOException e) {
            Assert.fail((String)("Unexpected exception: " + e.getClass().getName()));
        }
        try {
            FileUtils.copyDirectory((File)new File(this.archiveSourceDir, "petals-se-helloworld"), (File)saDir);
            repositorySvc.addServiceAssembly("petals-se-helloworld", saDir);
            Assert.fail((String)("The exception " + ServiceAssemblyAlreadyExistsException.class.getName() + " is not raised"));
        }
        catch (ServiceAssemblyAlreadyExistsException e) {
            Assert.assertEquals((Object)"petals-se-helloworld", (Object)e.getServiceAssemblyName());
            Assert.assertTrue((boolean)e.getMessage().contains("petals-se-helloworld"));
        }
        catch (IOException e) {
            Assert.fail((String)("Unexpected exception: " + e.getClass().getName()));
        }
    }

    @Test
    public void testAddServiceAssembly_003() throws Exception {
        File testHomeDir = new File(this.targetDir, "testAddServiceAssembly_003");
        if (testHomeDir.exists()) {
            try {
                FileUtils.deleteDirectory((File)testHomeDir);
            }
            catch (IOException e) {
                Assert.fail((String)"Unable to clean previous test execution.");
            }
        }
        File repositoryHomeDir = new File(testHomeDir, REPOSITORY_DIRNAME);
        Assert.assertTrue((boolean)repositoryHomeDir.mkdirs());
        RepositoryService repositorySvc = this.createRepositoryService(repositoryHomeDir.getAbsolutePath());
        File saDir = new File(testHomeDir, "sa");
        FileUtils.copyDirectory((File)new File(this.archiveSourceDir, "petals-se-helloworld"), (File)saDir);
        try {
            FileUtils.deleteDirectory((File)repositoryHomeDir);
        }
        catch (IOException e) {
            Assert.fail((String)"Unbale to delete the repository folder.");
        }
        try {
            repositorySvc.addServiceAssembly("petals-se-helloworld", saDir);
            Assert.fail((String)("The exception " + IOException.class.getName() + " is not raised"));
        }
        catch (ServiceAssemblyAlreadyExistsException e) {
            Assert.fail((String)("Unexpected exception: " + ((Object)((Object)e)).getClass().getName()));
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains(repositoryHomeDir.getAbsolutePath()));
        }
    }

    @Test
    public void testRemoveComponent_000() throws Exception {
        File testHomeDir = new File(this.targetDir, "testRemoveComponent_000");
        if (testHomeDir.exists()) {
            try {
                FileUtils.deleteDirectory((File)testHomeDir);
            }
            catch (IOException e) {
                Assert.fail((String)"Unable to clean previous test execution.");
            }
        }
        File repositoryHomeDir = new File(testHomeDir, REPOSITORY_DIRNAME);
        Assert.assertTrue((boolean)repositoryHomeDir.mkdirs());
        RepositoryService repositorySvc = this.createRepositoryService(repositoryHomeDir.getAbsolutePath());
        try {
            repositorySvc.removeComponent("petals-se-helloworld");
            Assert.fail((String)("The exception " + FileNotFoundException.class.getName() + " is not raised"));
        }
        catch (FileNotFoundException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("petals-se-helloworld"));
            Assert.assertTrue((boolean)e.getMessage().contains(RepositoryServiceImpl.EntityType.COMPONENT_TYPE.toString()));
        }
        catch (IOException e) {
            Assert.fail((String)("Unexpected exception: " + e.getClass().getName()));
        }
    }

    @Test
    public void testRemoveComponent_001() throws Exception {
        File testHomeDir = new File(this.targetDir, "testRemoveComponent_001");
        if (testHomeDir.exists()) {
            try {
                FileUtils.deleteDirectory((File)testHomeDir);
            }
            catch (IOException e) {
                Assert.fail((String)"Unable to clean previous test execution.");
            }
        }
        File repositoryHomeDir = new File(testHomeDir, REPOSITORY_DIRNAME);
        Assert.assertTrue((boolean)repositoryHomeDir.mkdirs());
        RepositoryService repositorySvc = this.createRepositoryService(repositoryHomeDir.getAbsolutePath());
        File componentDir = new File(testHomeDir, "component");
        FileUtils.copyDirectory((File)new File(this.archiveSourceDir, "petals-se-helloworld"), (File)componentDir);
        try {
            File installationRoot = repositorySvc.addComponent("petals-se-helloworld", componentDir);
            RepositoryServiceImplTest.assertComponentInstallationRoot(installationRoot, repositoryHomeDir);
            repositorySvc.removeComponent("petals-se-helloworld");
            Assert.assertEquals((String)"Remaining component in the repository", (long)0L, (long)installationRoot.getParentFile().getParentFile().list().length);
        }
        catch (ComponentAlreadyExistsException e) {
            Assert.fail((String)("Unexpected exception: " + ((Object)((Object)e)).getClass().getName()));
        }
        catch (FileNotFoundException e) {
            Assert.fail((String)("Unexpected exception: " + e.getClass().getName()));
        }
        catch (IOException e) {
            Assert.fail((String)("Unexpected exception: " + e.getClass().getName()));
        }
    }

    @Test
    public void testRemoveComponent_002() throws Exception {
        File testHomeDir = new File(this.targetDir, "testRemoveComponent_002");
        if (testHomeDir.exists()) {
            try {
                FileUtils.deleteDirectory((File)testHomeDir);
            }
            catch (IOException e) {
                Assert.fail((String)"Unable to clean previous test execution.");
            }
        }
        File repositoryHomeDir = new File(testHomeDir, REPOSITORY_DIRNAME);
        Assert.assertTrue((boolean)repositoryHomeDir.mkdirs());
        RepositoryService repositorySvc = this.createRepositoryService(repositoryHomeDir.getAbsolutePath());
        try {
            FileUtils.deleteDirectory((File)repositoryHomeDir);
        }
        catch (IOException e) {
            Assert.fail((String)"Unbale to delete the repository folder.");
        }
        try {
            repositorySvc.removeComponent("petals-se-helloworld");
            Assert.fail((String)("The exception " + IOException.class.getName() + " is not raised"));
        }
        catch (FileNotFoundException e) {
            Assert.fail((String)("Unexpected exception: " + e.getClass().getName()));
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains(repositoryHomeDir.getAbsolutePath()));
        }
    }

    @Test
    public void testRemoveSharedLibrary_000() throws Exception {
        File testHomeDir = new File(this.targetDir, "testRemoveSharedLibrary_000");
        if (testHomeDir.exists()) {
            try {
                FileUtils.deleteDirectory((File)testHomeDir);
            }
            catch (IOException e) {
                Assert.fail((String)"Unable to clean previous test execution.");
            }
        }
        File repositoryHomeDir = new File(testHomeDir, REPOSITORY_DIRNAME);
        Assert.assertTrue((boolean)repositoryHomeDir.mkdirs());
        RepositoryService repositorySvc = this.createRepositoryService(repositoryHomeDir.getAbsolutePath());
        try {
            repositorySvc.removeSharedLibrary("petals-se-helloworld", SL_VERSION);
            Assert.fail((String)("The exception " + FileNotFoundException.class.getName() + " is not raised"));
        }
        catch (FileNotFoundException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("petals-se-helloworld"));
            Assert.assertTrue((boolean)e.getMessage().contains(SL_VERSION));
            Assert.assertTrue((boolean)e.getMessage().contains(RepositoryServiceImpl.EntityType.SL_TYPE.toString()));
        }
        catch (IOException e) {
            Assert.fail((String)("Unexpected exception: " + e.getClass().getName()));
        }
    }

    @Test
    public void testRemoveSharedLibrary_001() throws Exception {
        File testHomeDir = new File(this.targetDir, "testRemoveSharedLibrary_001");
        if (testHomeDir.exists()) {
            try {
                FileUtils.deleteDirectory((File)testHomeDir);
            }
            catch (IOException e) {
                Assert.fail((String)"Unable to clean previous test execution.");
            }
        }
        File repositoryHomeDir = new File(testHomeDir, REPOSITORY_DIRNAME);
        Assert.assertTrue((boolean)repositoryHomeDir.mkdirs());
        RepositoryService repositorySvc = this.createRepositoryService(repositoryHomeDir.getAbsolutePath());
        File slDir = new File(testHomeDir, "sl");
        FileUtils.copyDirectory((File)new File(this.archiveSourceDir, "petals-se-helloworld"), (File)slDir);
        try {
            File installationRoot = repositorySvc.addSharedLibrary("petals-se-helloworld", SL_VERSION, slDir);
            RepositoryServiceImplTest.assertSharedLibraryInstallationRoot(installationRoot, repositoryHomeDir);
            repositorySvc.removeSharedLibrary("petals-se-helloworld", SL_VERSION);
            Assert.assertEquals((String)"Remaining shared library in the repository", (long)0L, (long)installationRoot.getParentFile().getParentFile().list().length);
        }
        catch (SharedLibraryAlreadyExistsException e) {
            Assert.fail((String)("Unexpected exception: " + ((Object)((Object)e)).getClass().getName()));
        }
        catch (FileNotFoundException e) {
            Assert.fail((String)("Unexpected exception: " + e.getClass().getName()));
        }
        catch (IOException e) {
            Assert.fail((String)("Unexpected exception: " + e.getClass().getName()));
        }
    }

    @Test
    public void testRemoveSharedLibrary_002() throws Exception {
        File testHomeDir = new File(this.targetDir, "testRemoveSharedLibrary_002");
        if (testHomeDir.exists()) {
            try {
                FileUtils.deleteDirectory((File)testHomeDir);
            }
            catch (IOException e) {
                Assert.fail((String)"Unable to clean previous test execution.");
            }
        }
        File repositoryHomeDir = new File(testHomeDir, REPOSITORY_DIRNAME);
        Assert.assertTrue((boolean)repositoryHomeDir.mkdirs());
        RepositoryService repositorySvc = this.createRepositoryService(repositoryHomeDir.getAbsolutePath());
        try {
            FileUtils.deleteDirectory((File)repositoryHomeDir);
        }
        catch (IOException e) {
            Assert.fail((String)"Unbale to delete the repository folder.");
        }
        try {
            repositorySvc.removeSharedLibrary("petals-se-helloworld", SL_VERSION);
            Assert.fail((String)("The exception " + IOException.class.getName() + " is not raised"));
        }
        catch (FileNotFoundException e) {
            Assert.fail((String)("Unexpected exception: " + e.getClass().getName()));
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains(repositoryHomeDir.getAbsolutePath()));
        }
    }

    @Test
    public void testRemoveServiceAssembly_000() throws Exception {
        File testHomeDir = new File(this.targetDir, "testRemoveServiceAssembly_000");
        if (testHomeDir.exists()) {
            try {
                FileUtils.deleteDirectory((File)testHomeDir);
            }
            catch (IOException e) {
                Assert.fail((String)"Unable to clean previous test execution.");
            }
        }
        File repositoryHomeDir = new File(testHomeDir, REPOSITORY_DIRNAME);
        Assert.assertTrue((boolean)repositoryHomeDir.mkdirs());
        RepositoryService repositorySvc = this.createRepositoryService(repositoryHomeDir.getAbsolutePath());
        try {
            repositorySvc.removeServiceAssembly("petals-se-helloworld");
            Assert.fail((String)("The exception " + FileNotFoundException.class.getName() + " is not raised"));
        }
        catch (FileNotFoundException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("petals-se-helloworld"));
            Assert.assertTrue((boolean)e.getMessage().contains(RepositoryServiceImpl.EntityType.SA_TYPE.toString()));
        }
        catch (IOException e) {
            Assert.fail((String)("Unexpected exception: " + e.getClass().getName()));
        }
    }

    @Test
    public void testRemoveServiceAssembly_001() throws Exception {
        File testHomeDir = new File(this.targetDir, "testRemoveServiceAssembly_001");
        if (testHomeDir.exists()) {
            try {
                FileUtils.deleteDirectory((File)testHomeDir);
            }
            catch (IOException e) {
                Assert.fail((String)"Unable to clean previous test execution.");
            }
        }
        File repositoryHomeDir = new File(testHomeDir, REPOSITORY_DIRNAME);
        Assert.assertTrue((boolean)repositoryHomeDir.mkdirs());
        RepositoryService repositorySvc = this.createRepositoryService(repositoryHomeDir.getAbsolutePath());
        File saDir = new File(testHomeDir, "sA");
        FileUtils.copyDirectory((File)new File(this.archiveSourceDir, "petals-se-helloworld"), (File)saDir);
        try {
            File installationRoot = repositorySvc.addServiceAssembly("petals-se-helloworld", saDir);
            RepositoryServiceImplTest.assertServiceAssemblyInstallationRoot(installationRoot, repositoryHomeDir);
            repositorySvc.removeServiceAssembly("petals-se-helloworld");
            Assert.assertEquals((String)"Remaining service assembly in the repository", (long)0L, (long)installationRoot.getParentFile().getParentFile().list().length);
        }
        catch (ServiceAssemblyAlreadyExistsException e) {
            Assert.fail((String)("Unexpected exception: " + ((Object)((Object)e)).getClass().getName()));
        }
        catch (FileNotFoundException e) {
            Assert.fail((String)("Unexpected exception: " + e.getClass().getName()));
        }
        catch (IOException e) {
            Assert.fail((String)("Unexpected exception: " + e.getClass().getName()));
        }
    }

    @Test
    public void testRemoveServiceAssembly_002() throws Exception {
        File testHomeDir = new File(this.targetDir, "testRemoveServiceAssembly_002");
        if (testHomeDir.exists()) {
            try {
                FileUtils.deleteDirectory((File)testHomeDir);
            }
            catch (IOException e) {
                Assert.fail((String)"Unable to clean previous test execution.");
            }
        }
        File repositoryHomeDir = new File(testHomeDir, REPOSITORY_DIRNAME);
        Assert.assertTrue((boolean)repositoryHomeDir.mkdirs());
        RepositoryService repositorySvc = this.createRepositoryService(repositoryHomeDir.getAbsolutePath());
        try {
            FileUtils.deleteDirectory((File)repositoryHomeDir);
        }
        catch (IOException e) {
            Assert.fail((String)"Unbale to delete the repository folder.");
        }
        try {
            repositorySvc.removeServiceAssembly("petals-se-helloworld");
            Assert.fail((String)("The exception " + IOException.class.getName() + " is not raised"));
        }
        catch (FileNotFoundException e) {
            Assert.fail((String)("Unexpected exception: " + e.getClass().getName()));
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains(repositoryHomeDir.getAbsolutePath()));
        }
    }
}

