/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.util.ZipUtil;

public class ZipUtilTest {
    private File baseDir = null;
    private File testResourcesDir = null;
    private File extractedDir = null;

    @Before
    public void setUp() {
        String baseDirPath = this.getClass().getResource(".").getPath();
        baseDirPath = baseDirPath.substring(0, baseDirPath.indexOf("target"));
        baseDirPath = baseDirPath.substring(baseDirPath.indexOf(":") + 1);
        try {
            this.baseDir = new File(new URI("file:" + baseDirPath).normalize());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        this.testResourcesDir = new File(this.baseDir, "src" + File.separator + "test" + File.separator + "resources");
        this.extractedDir = new File(this.testResourcesDir, "extracted");
    }

    @Test
    public void testExplodeZip() throws PetalsException, IOException {
        this.extractedDir.delete();
        this.extractedDir.mkdir();
        ZipUtil.unzipArchive((File)new File(this.testResourcesDir, "test-ziputil.zip"), (File)this.extractedDir);
        if (this.extractedDir.listFiles().length != 3) {
            Assert.fail();
        }
        FileUtils.forceDelete((File)this.extractedDir);
    }

    @Test
    public void testExplodeZip1() {
        try {
            ZipUtil.unzipArchive(null, (File)this.extractedDir);
            Assert.fail();
        }
        catch (NullPointerException e) {
        }
        catch (IOException e) {
            Assert.fail((String)("IOException raised: " + e.getMessage()));
        }
    }

    @Test
    public void testGetEntryAsTemp() throws IOException, PetalsException {
        Assert.assertNotNull((Object)ZipUtil.getEntryAsTemp((ZipFile)new ZipFile(this.testResourcesDir.getAbsolutePath() + File.separator + "test-ziputil.zip"), (String)"META-INF/jbi.xml"));
    }

    @Test
    public void testGetEntryAsTemp1() throws IOException {
        try {
            ZipUtil.getEntryAsTemp((ZipFile)new ZipFile(this.testResourcesDir.getAbsolutePath() + File.separator + "test-ziputil.zip"), (String)("META-INF" + File.separator + "manifest.mf"));
            Assert.fail();
        }
        catch (PetalsException petalsException) {
            // empty catch block
        }
    }

    @Test
    public void testGetEntryAsTemp2() {
        try {
            ZipUtil.getEntryAsTemp((ZipFile)null, (String)("META-INF" + File.separator + "manifest.mf"));
            Assert.fail();
        }
        catch (NullPointerException e) {
        }
        catch (IOException e) {
            Assert.fail((String)("PetalsException raised: " + e.getMessage()));
        }
        catch (PetalsException e) {
            Assert.fail((String)("PetalsException raised: " + e.getMessage()));
        }
    }

    @Test
    public void testGetEntryAsTemp3() {
        try {
            ZipUtil.getEntryAsTemp((ZipFile)new ZipFile(this.testResourcesDir.getAbsolutePath() + File.separator + "test-ziputil.zip"), (String)null);
            Assert.fail();
        }
        catch (NullPointerException e) {
        }
        catch (PetalsException e) {
            Assert.fail((String)("PetalsException raised: " + e.getMessage()));
        }
        catch (IOException e) {
            Assert.fail((String)("IOException raised: " + e.getMessage()));
        }
    }

    @Test
    public void testGetEntryAsTemp4() {
        try {
            ZipUtil.getEntryAsTemp((ZipFile)new ZipFile(this.testResourcesDir.getAbsolutePath() + File.separator + "test-ziputil.zip"), (String)"");
            Assert.fail();
        }
        catch (PetalsException e) {
        }
        catch (IOException e) {
            Assert.fail((String)("IOException raised: " + e.getMessage()));
        }
    }
}

