/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.configuration;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ow2.petals.launcher.configuration.Configuration;
import org.ow2.petals.launcher.configuration.ConfigurationException;
import org.ow2.petals.launcher.configuration.DefaultConfiguration;

public class DefaultConfigurationTest {
    private Configuration validConfig;
    private File validHome;

    public static synchronized File createTempDirectory() throws IOException {
        File tmpdir = File.createTempFile("petals", "home");
        tmpdir.delete();
        tmpdir.mkdirs();
        tmpdir.deleteOnExit();
        return tmpdir;
    }

    public static File createPetalsHomeDirectory() throws ConfigurationException {
        try {
            File home = DefaultConfigurationTest.createTempDirectory();
            for (String s : new String[]{"conf", "install", "installed", "lib", "work"}) {
                new File(home, s).mkdirs();
            }
            File dir = new File(home, "conf");
            dir.mkdirs();
            URL urlServerProperties = ClassLoader.getSystemResource("server.properties");
            File serverProperties = new File(dir, "server.properties");
            FileUtils.copyURLToFile((URL)urlServerProperties, (File)serverProperties);
            Assert.assertTrue((boolean)serverProperties.isFile());
            Assert.assertTrue((serverProperties.length() > 0L ? 1 : 0) != 0);
            URL urlTopology = ClassLoader.getSystemResource("topology.xml");
            File topology = new File(dir, "topology.xml");
            FileUtils.copyURLToFile((URL)urlTopology, (File)topology);
            Assert.assertTrue((boolean)topology.isFile());
            Assert.assertTrue((topology.length() > 0L ? 1 : 0) != 0);
            return home;
        }
        catch (IOException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    @Before
    public void setUp() throws Exception {
        this.validHome = DefaultConfigurationTest.createPetalsHomeDirectory();
        Assert.assertTrue((boolean)this.validHome.isDirectory());
        this.validConfig = new DefaultConfiguration(this.validHome.getAbsolutePath());
    }

    @After
    public void tearDown() throws Exception {
        FileUtils.deleteDirectory((File)this.validHome);
    }

    @Test
    public final void testDefaultConfiguration() {
        try {
            new DefaultConfiguration(null);
            Assert.fail((String)"a NullPointerException should have been thrown");
        }
        catch (NullPointerException npe) {
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        DefaultConfiguration c = null;
        try {
            c = new DefaultConfiguration(".");
            Assert.assertEquals((Object)new File("."), (Object)c.getHomeDirectory());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public final void testGetConfDirectory() {
        try {
            File d1 = new File(this.validHome, "conf");
            File d2 = this.validConfig.getConfDirectory();
            Assert.assertEquals((Object)d1, (Object)d2);
        }
        catch (ConfigurationException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public final void testGetHomeDirectory() {
        try {
            File d1 = this.validHome;
            File d2 = this.validConfig.getHomeDirectory();
            Assert.assertEquals((Object)d1, (Object)d2);
        }
        catch (ConfigurationException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public final void testGetInstallDirectory() {
        try {
            File d1 = new File(this.validHome, "install");
            File d2 = this.validConfig.getInstallDirectory();
            Assert.assertEquals((Object)d1, (Object)d2);
        }
        catch (ConfigurationException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public final void testGetInstalledDirectory() {
        try {
            File d1 = new File(this.validHome, "installed");
            File d2 = this.validConfig.getInstalledDirectory();
            Assert.assertEquals((Object)d1, (Object)d2);
        }
        catch (ConfigurationException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public final void testGetLibDirectory() {
        try {
            File d1 = new File(this.validHome, "lib");
            File d2 = this.validConfig.getLibDirectory();
            Assert.assertEquals((Object)d1, (Object)d2);
        }
        catch (ConfigurationException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public final void testGetWorkDirectory() {
        try {
            File d1 = new File(this.validHome, "work");
            File d2 = this.validConfig.getWorkDirectory();
            Assert.assertEquals((Object)d1, (Object)d2);
        }
        catch (ConfigurationException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public final void testGetStartupTimeoutSeconds() {
        try {
            int timeout = this.validConfig.getStartupTimeoutSeconds();
            Assert.assertTrue((timeout > 0 ? 1 : 0) != 0);
        }
        catch (ConfigurationException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public final void testIsValid() {
        File tmp = null;
        try {
            Assert.assertTrue((boolean)this.validConfig.isValid());
            tmp = DefaultConfigurationTest.createTempDirectory();
            DefaultConfiguration c = new DefaultConfiguration(tmp.getAbsolutePath());
            Assert.assertFalse((boolean)c.isValid());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (tmp != null) {
                tmp.delete();
            }
        }
    }
}

