/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.messaging.exchange;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.jbi.messaging.MessagingException;
import javax.security.auth.Subject;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.ow2.petals.jbi.messaging.exchange.NormalizedMessageImpl;

public class NormalizedMessageImplTest {
    private NormalizedMessageImpl normalizedMessageImpl;
    private FileDataSource source;
    private String baseDir;

    @Before
    public void before() {
        this.baseDir = this.getClass().getResource(".").toString();
        this.baseDir = this.baseDir.substring(0, this.baseDir.indexOf("target"));
        this.baseDir = this.baseDir.substring(this.baseDir.indexOf(":") + 1);
        try {
            this.source = new FileDataSource(new File(new URI("file", null, this.baseDir.replace(File.separator, "/") + "/src/test/resources/filesource.txt", null).normalize()));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        this.normalizedMessageImpl = new NormalizedMessageImpl();
    }

    @Test
    public void testAddAttachment() throws IOException {
        try {
            this.normalizedMessageImpl.addAttachment("test", new DataHandler((DataSource)this.source));
        }
        catch (MessagingException e) {
            Assert.fail();
        }
    }

    @Test
    public void testGetAttachment() throws IOException {
        this.testAddAttachment();
        DataHandler dataHandler = this.normalizedMessageImpl.getAttachment("test");
        String content = (String)dataHandler.getContent();
        Assert.assertEquals((Object)content, (Object)"File used to test the normalized message");
    }

    @Test
    public void testGetContent() throws IOException, MessagingException {
        this.normalizedMessageImpl = new NormalizedMessageImpl();
        StreamSource xml = new StreamSource(new File(this.baseDir + "src" + File.separator + "test" + File.separator + "resources" + File.separator + "descriptors" + File.separator + "sharedLibraryInstallationDescriptor.xml"));
        this.normalizedMessageImpl.setContent((Source)xml);
        StreamSource source = (StreamSource)this.normalizedMessageImpl.getContent();
        Assert.assertEquals((Object)source, (Object)xml);
    }

    @Test
    public void testGetAttachmentNames() throws IOException {
        this.testAddAttachment();
        Assert.assertEquals(this.normalizedMessageImpl.getAttachmentNames().iterator().next(), (Object)"test");
    }

    @Test
    public void testRemoveAttachment() throws IOException, MessagingException {
        this.testAddAttachment();
        this.normalizedMessageImpl.removeAttachment("test");
        Assert.assertNull((Object)this.normalizedMessageImpl.getAttachment("test"));
    }

    @Test
    public void testRemoveAttachment1() throws IOException, MessagingException {
        this.testAddAttachment();
        try {
            this.normalizedMessageImpl.removeAttachment("foo");
            Assert.fail();
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
    }

    @Test
    public void testGetPropertyNames() throws IOException {
        this.normalizedMessageImpl = new NormalizedMessageImpl();
        this.normalizedMessageImpl.setProperty("test", (Object)"value");
        Assert.assertEquals(this.normalizedMessageImpl.getPropertyNames().iterator().next(), (Object)"test");
    }

    @Test
    public void testGetSecuritySubject() {
        Subject subject = new Subject();
        this.normalizedMessageImpl.setSecuritySubject(subject);
        Assert.assertEquals((Object)this.normalizedMessageImpl.getSecuritySubject(), (Object)subject);
    }

    @Test
    public void testSetProperty() {
        this.normalizedMessageImpl.properties.put("test", Mockito.mock(DataHandler.class));
        this.normalizedMessageImpl.setProperty("test", null);
        Assert.assertNull(this.normalizedMessageImpl.attachments.get("test"));
    }
}

