package org.ow2.petals.jbi.messaging.exchange;

import java.net.URI;
import java.net.URISyntaxException;

/**
 * Constants for the Patterns.
 * 
 */
public enum MEPPatternConstants {
    IN_ONLY("http://www.w3.org/ns/wsdl/in-only"), ROBUST_IN_ONLY(
            "http://www.w3.org/ns/wsdl/robust-in-only"),
    IN_OUT("http://www.w3.org/ns/wsdl/in-out"), IN_OPTIONAL_OUT(
            "http://www.w3.org/ns/wsdl/in-optional-out"), OUT_ONLY(
            "http://www.w3.org/ns/wsdl/out-only"), ROBUST_OUT_ONLY(
            "http://www.w3.org/ns/wsdl/robust-out-only"),
    OUT_IN("http://www.w3.org/ns/wsdl/out-in"), OUT_OPTIONAL_IN(
            "http://www.w3.org/ns/wsdl/out-optional-in");

    /**
     * 
     * @param pattern
     * @return
     */
    public static MEPPatternConstants valueOf(final URI pattern) {
        MEPPatternConstants result = null;
        if (pattern != null) {
            for (final MEPPatternConstants p : MEPPatternConstants.values()) {
                if (p.nameSpace.equals(pattern.toString())) {
                    result = p;
                }
            }
        }
        return result;
    }

    private final String nameSpace;

    private final URI patternURI;

    /**
     * Creates a new instance of {@link MEPPatternConstants}
     * 
     * @param nameSpace
     */
    private MEPPatternConstants(final String nameSpace) {
        this.nameSpace = nameSpace;
        try {
            this.patternURI = new URI(nameSpace);
        } catch (final URISyntaxException e) {
            throw new Error("Unexpected Error in URI namespace syntax", e);
        }
    }

    /**
     * 
     * @return
     */
    public URI value() {
        return this.patternURI;
    }

    /**
     * Please use this equals method instead of using :<code>
     * value().equals(pattern)
     * </code> which is almost 10 times slower...
     * 
     * @param mep
     * @return
     */
    public boolean equals(final URI pattern) {
        return (pattern != null && this.toString().equals(pattern.toString()));
    }

    /**
     * (non-Javadoc)
     * 
     * @see java.lang.Enum#toString()
     */
    @Override
    public String toString() {
        return this.nameSpace;
    }
}
