/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.messaging.exchange;

import com.ebmwebsourcing.easycommons.xml.Transformers;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class MessageExchangeSerializer {
    private MessageExchangeSerializer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void serializeContent(Source content, ObjectOutputStream outStream, boolean compress) throws Exception {
        if (content == null) {
            outStream.writeBoolean(false);
        } else {
            outStream.writeBoolean(true);
            Source source = content;
            synchronized (source) {
                StreamResult sresult = null;
                GZIPOutputStream gz = null;
                if (compress) {
                    gz = new GZIPOutputStream(outStream);
                    sresult = new StreamResult(gz);
                } else {
                    sresult = new StreamResult(outStream);
                }
                Transformer transformer = Transformers.takeTransformer();
                try {
                    transformer.transform(content, sresult);
                }
                finally {
                    Transformers.releaseTransformer((Transformer)transformer);
                }
                if (compress) {
                    gz.finish();
                }
            }
        }
    }

    public static final Source deserializeContent(ObjectInputStream inStream, boolean compress) throws IOException {
        StreamSource source = null;
        if (inStream.readBoolean()) {
            source = new StreamSource();
            InputStream in = inStream;
            if (compress) {
                in = new GZIPInputStream(inStream);
            }
            byte[] buffer = new byte[4098];
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            int n = 0;
            while (-1 != (n = in.read(buffer))) {
                outputStream.write(buffer, 0, n);
            }
            ByteArrayInputStream result = new ByteArrayInputStream(outputStream.toByteArray());
            source.setInputStream(result);
        }
        return source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void serializeAttachments(Map<String, DataHandler> attachments, ObjectOutputStream s) throws Exception {
        s.writeInt(attachments.size());
        for (Map.Entry<String, DataHandler> attachment : attachments.entrySet()) {
            InputStream binary = attachment.getValue().getInputStream();
            try {
                int available = binary.available();
                s.writeUTF(attachment.getKey());
                s.writeUTF(attachment.getValue().getContentType());
                s.writeUTF(attachment.getValue().getName());
                s.writeInt(available);
                byte[] buff = new byte[4097];
                int n = 0;
                while (-1 != (n = binary.read(buff))) {
                    s.write(buff, 0, n);
                    s.flush();
                }
            }
            finally {
                binary.close();
            }
        }
    }

    public static final Map<String, DataHandler> deserializeAttachments(ObjectInputStream s) throws IOException {
        HashMap<String, DataHandler> attachments = new HashMap<String, DataHandler>();
        int attachmentsCount = s.readInt();
        for (int i = 0; i < attachmentsCount; ++i) {
            String attachmentName = s.readUTF();
            String contentType = s.readUTF();
            String name = s.readUTF();
            int available = s.readInt();
            byte[] content = new byte[available];
            s.readFully(content);
            ByteArrayDataSource dataSource = new ByteArrayDataSource(content, contentType);
            dataSource.setName(name);
            DataHandler dataHandler = new DataHandler((DataSource)dataSource);
            attachments.put(attachmentName, dataHandler);
        }
        return attachments;
    }
}

