/**
 * 
 */

package org.ow2.petals.jbi.messaging.exchange;

import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;

import org.ow2.petals.commons.Constants;
import org.ow2.petals.commons.PetalsExecutionContext;

import com.ebmwebsourcing.easycommons.uuid.QualifiedUUIDGenerator;

/**
 * 
 * @author ofabre
 * 
 */
public class ContextualMessageExchangeImplBuilder {

    private static final QualifiedUUIDGenerator petalsQualifiedUUIDGenerator = new QualifiedUUIDGenerator(
            Constants.UUID_DOMAIN);

    /**
     * The reply address for any service request
     */
    private final ServiceEndpoint consumerEndpoint;
    
    private final ServiceEndpoint defaultEndpoint;
    
    private final QName defaultInterfaceName;
    
    private final QName defaultServiceName;

    private ContextualMessageExchangeImplBuilder(ServiceEndpoint consumerEndpoint, ServiceEndpoint targetEndpoint, QName targetInterface, QName targetService) {
        this.consumerEndpoint = consumerEndpoint;
        this.defaultEndpoint = targetEndpoint;
        this.defaultInterfaceName = targetInterface;
        this.defaultServiceName = targetService;
    }

    public static final ContextualMessageExchangeImplBuilder createMessageExchangeImplBuilder(ServiceEndpoint consumerEndpoint) {
        return new ContextualMessageExchangeImplBuilder(consumerEndpoint, null, null, null);
    }

    public static final ContextualMessageExchangeImplBuilder createMessageExchangeImplBuilderForEndpoint(ServiceEndpoint consumerEndpoint, ServiceEndpoint targetEndpoint) {
        return new ContextualMessageExchangeImplBuilder(consumerEndpoint, targetEndpoint, null, null);
    }
    
    public static final ContextualMessageExchangeImplBuilder createMessageExchangeImplBuilderForInterface(ServiceEndpoint consumerEndpoint, QName targetInterface) {
        return new ContextualMessageExchangeImplBuilder(consumerEndpoint, null, targetInterface, null);
    }    
    
    public static final ContextualMessageExchangeImplBuilder createMessageExchangeImplBuilderForService(ServiceEndpoint consumerEndpoint, QName targetService) {
        return new ContextualMessageExchangeImplBuilder(consumerEndpoint, null, null, targetService);
    }

    protected MessageExchangeImpl build() throws MessagingException {
        MessageExchangeImpl msg = new MessageExchangeImpl();
        msg.setExchangeId(petalsQualifiedUUIDGenerator.getNewID());
        msg.setConsumerEndpoint(consumerEndpoint);
        msg.setEndpoint(defaultEndpoint);
        msg.setInterfaceName(defaultInterfaceName);
        msg.setService(defaultServiceName);
        msg.setFlowAttributes(PetalsExecutionContext.getFlowAttributes());
        return msg;
    }
}
