/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.messaging.exchange;

import com.ebmwebsourcing.easycommons.thread.ExecutionContext;
import javax.jbi.messaging.FlowAttributes;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.ow2.petals.commons.PetalsExecutionContext;
import org.ow2.petals.jbi.messaging.exchange.ContextualMessageExchangeImplBuilder;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeCheckHelper;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeImpl;

public class ContextualMessageExchangeImplBuilderTest
extends MessageExchangeCheckHelper {
    private ServiceEndpoint consumerEndpointMock = (ServiceEndpoint)Mockito.mock(ServiceEndpoint.class);

    @After
    public void after() {
        ExecutionContext.getProperties().clear();
    }

    @Test
    public void testBuildUseBuilderConsumerEp() throws MessagingException {
        ContextualMessageExchangeImplBuilder contextualMessageExchangeImplBuilder = ContextualMessageExchangeImplBuilder.createMessageExchangeImplBuilder((ServiceEndpoint)this.consumerEndpointMock);
        MessageExchangeImpl messageExchangeImpl = contextualMessageExchangeImplBuilder.build();
        Assert.assertEquals((Object)this.consumerEndpointMock, (Object)messageExchangeImpl.getConsumerEndpoint());
    }

    @Test
    public void testBuildUseBuilderConsumerEpForEndpoint() throws MessagingException {
        ServiceEndpoint serviceEndpoint = (ServiceEndpoint)Mockito.mock(ServiceEndpoint.class);
        ContextualMessageExchangeImplBuilder contextualMessageExchangeImplBuilder = ContextualMessageExchangeImplBuilder.createMessageExchangeImplBuilderForEndpoint((ServiceEndpoint)this.consumerEndpointMock, (ServiceEndpoint)serviceEndpoint);
        MessageExchangeImpl messageExchangeImpl = contextualMessageExchangeImplBuilder.build();
        Assert.assertEquals((Object)this.consumerEndpointMock, (Object)messageExchangeImpl.getConsumerEndpoint());
        Assert.assertEquals((Object)serviceEndpoint, (Object)messageExchangeImpl.getEndpoint());
    }

    @Test
    public void testBuildUseBuilderConsumerEpForInterface() throws MessagingException {
        QName qName = new QName("http://test", "interface");
        ContextualMessageExchangeImplBuilder contextualMessageExchangeImplBuilder = ContextualMessageExchangeImplBuilder.createMessageExchangeImplBuilderForInterface((ServiceEndpoint)this.consumerEndpointMock, (QName)qName);
        MessageExchangeImpl messageExchangeImpl = contextualMessageExchangeImplBuilder.build();
        Assert.assertEquals((Object)this.consumerEndpointMock, (Object)messageExchangeImpl.getConsumerEndpoint());
        Assert.assertEquals((Object)qName, (Object)messageExchangeImpl.getInterfaceName());
    }

    @Test
    public void testBuildUseBuilderConsumerEpForService() throws MessagingException {
        QName qName = new QName("http://test", "service");
        ContextualMessageExchangeImplBuilder contextualMessageExchangeImplBuilder = ContextualMessageExchangeImplBuilder.createMessageExchangeImplBuilderForService((ServiceEndpoint)this.consumerEndpointMock, (QName)qName);
        MessageExchangeImpl messageExchangeImpl = contextualMessageExchangeImplBuilder.build();
        Assert.assertEquals((Object)this.consumerEndpointMock, (Object)messageExchangeImpl.getConsumerEndpoint());
        Assert.assertEquals((Object)qName, (Object)messageExchangeImpl.getService());
    }

    @Test
    public void testBuildGenerateUUIDExchangeId() throws MessagingException {
        ContextualMessageExchangeImplBuilder contextualMessageExchangeImplBuilder = ContextualMessageExchangeImplBuilder.createMessageExchangeImplBuilder((ServiceEndpoint)this.consumerEndpointMock);
        MessageExchangeImpl messageExchangeImpl = contextualMessageExchangeImplBuilder.build();
        String string = messageExchangeImpl.getExchangeId();
        this.assertIdIsPetalsQualifiedUUID(string);
    }

    @Test
    public void testBuildWithNonNullFlowAttributesInContext() throws MessagingException {
        FlowAttributes flowAttributes = new FlowAttributes("flowInstanceId1", "flowStepId1");
        PetalsExecutionContext.putFlowAttributes((FlowAttributes)flowAttributes);
        ContextualMessageExchangeImplBuilder contextualMessageExchangeImplBuilder = ContextualMessageExchangeImplBuilder.createMessageExchangeImplBuilder((ServiceEndpoint)this.consumerEndpointMock);
        MessageExchangeImpl messageExchangeImpl = contextualMessageExchangeImplBuilder.build();
        Assert.assertEquals((Object)flowAttributes, (Object)messageExchangeImpl.getFlowAttributes());
    }

    @Test
    public void testBuildWithNoFlowAttributesInContext() throws MessagingException {
        ContextualMessageExchangeImplBuilder contextualMessageExchangeImplBuilder = ContextualMessageExchangeImplBuilder.createMessageExchangeImplBuilder((ServiceEndpoint)this.consumerEndpointMock);
        MessageExchangeImpl messageExchangeImpl = contextualMessageExchangeImplBuilder.build();
        Assert.assertNull((Object)messageExchangeImpl.getFlowAttributes());
    }

    @Test
    public void testBuildButMissingFlowInstanceIdInContext() throws MessagingException {
        ExecutionContext.getProperties().setProperty("flowStepId", "flowStepId1");
        ContextualMessageExchangeImplBuilder contextualMessageExchangeImplBuilder = ContextualMessageExchangeImplBuilder.createMessageExchangeImplBuilder((ServiceEndpoint)this.consumerEndpointMock);
        MessageExchangeImpl messageExchangeImpl = contextualMessageExchangeImplBuilder.build();
        Assert.assertNull((Object)messageExchangeImpl.getFlowAttributes());
    }

    @Test
    public void testBuildButMissingFlowStepIdInContext() throws MessagingException {
        ExecutionContext.getProperties().setProperty("flowInstanceId", "flowInstanceId1");
        ContextualMessageExchangeImplBuilder contextualMessageExchangeImplBuilder = ContextualMessageExchangeImplBuilder.createMessageExchangeImplBuilder((ServiceEndpoint)this.consumerEndpointMock);
        MessageExchangeImpl messageExchangeImpl = contextualMessageExchangeImplBuilder.build();
        Assert.assertNull((Object)messageExchangeImpl.getFlowAttributes());
    }
}

