/****************************************************************************
 *
 * Copyright (c) 2006-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/
 
package org.ow2.petals.jbi.messaging.exchange;

import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;

import org.ow2.petals.commons.Constants;
import org.ow2.petals.commons.PetalsExecutionContext;

import com.ebmwebsourcing.easycommons.uuid.QualifiedUUIDGenerator;

/**
 * @author Olivier Fabre - EBM WebSourcing
 */
public class ContextualMessageExchangeImplBuilder {

    private static final QualifiedUUIDGenerator petalsQualifiedUUIDGenerator = new QualifiedUUIDGenerator(
            Constants.UUID_DOMAIN);

    /**
     * The reply address for any service request
     */
    private final ServiceEndpoint consumerEndpoint;
    
    private final ServiceEndpoint defaultEndpoint;
    
    private final QName defaultInterfaceName;
    
    private final QName defaultServiceName;

    private ContextualMessageExchangeImplBuilder(ServiceEndpoint consumerEndpoint, ServiceEndpoint targetEndpoint, QName targetInterface, QName targetService) {
        this.consumerEndpoint = consumerEndpoint;
        this.defaultEndpoint = targetEndpoint;
        this.defaultInterfaceName = targetInterface;
        this.defaultServiceName = targetService;
    }

    public static final ContextualMessageExchangeImplBuilder createMessageExchangeImplBuilder(ServiceEndpoint consumerEndpoint) {
        return new ContextualMessageExchangeImplBuilder(consumerEndpoint, null, null, null);
    }

    public static final ContextualMessageExchangeImplBuilder createMessageExchangeImplBuilderForEndpoint(ServiceEndpoint consumerEndpoint, ServiceEndpoint targetEndpoint) {
        return new ContextualMessageExchangeImplBuilder(consumerEndpoint, targetEndpoint, null, null);
    }
    
    public static final ContextualMessageExchangeImplBuilder createMessageExchangeImplBuilderForInterface(ServiceEndpoint consumerEndpoint, QName targetInterface) {
        return new ContextualMessageExchangeImplBuilder(consumerEndpoint, null, targetInterface, null);
    }    
    
    public static final ContextualMessageExchangeImplBuilder createMessageExchangeImplBuilderForService(ServiceEndpoint consumerEndpoint, QName targetService) {
        return new ContextualMessageExchangeImplBuilder(consumerEndpoint, null, null, targetService);
    }

    protected MessageExchangeImpl build() throws MessagingException {
        MessageExchangeImpl msg = new MessageExchangeImpl();
        msg.setExchangeId(petalsQualifiedUUIDGenerator.getNewID());
        msg.setConsumerEndpoint(consumerEndpoint);
        msg.setEndpoint(defaultEndpoint);
        msg.setInterfaceName(defaultInterfaceName);
        msg.setService(defaultServiceName);
        msg.setFlowAttributes(PetalsExecutionContext.getFlowAttributes());
        return msg;
    }
}
