/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.messaging.exchange;

import com.ebmwebsourcing.easycommons.thread.ExecutionContext;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.ow2.petals.commons.log.FlowAttributes;
import org.ow2.petals.commons.log.PetalsExecutionContext;
import org.ow2.petals.jbi.messaging.exchange.ContextualMessageExchangeImplBuilder;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeCheckHelper;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeImpl;

public class ContextualMessageExchangeImplBuilderTest
extends MessageExchangeCheckHelper {
    private ServiceEndpoint consumerEndpointMock = (ServiceEndpoint)Mockito.mock(ServiceEndpoint.class);

    @After
    public void after() {
        ExecutionContext.getProperties().clear();
    }

    @Test
    public void testBuildUseBuilderConsumerEp() throws MessagingException {
        ContextualMessageExchangeImplBuilder messageExchangeImplBuilder = ContextualMessageExchangeImplBuilder.createMessageExchangeImplBuilder((ServiceEndpoint)this.consumerEndpointMock);
        MessageExchangeImpl messageExchangeImpl = messageExchangeImplBuilder.build();
        Assert.assertEquals((Object)this.consumerEndpointMock, (Object)messageExchangeImpl.getConsumerEndpoint());
    }

    @Test
    public void testBuildUseBuilderConsumerEpForEndpoint() throws MessagingException {
        ServiceEndpoint targetEndpointMock = (ServiceEndpoint)Mockito.mock(ServiceEndpoint.class);
        ContextualMessageExchangeImplBuilder messageExchangeImplBuilder = ContextualMessageExchangeImplBuilder.createMessageExchangeImplBuilderForEndpoint((ServiceEndpoint)this.consumerEndpointMock, (ServiceEndpoint)targetEndpointMock);
        MessageExchangeImpl messageExchangeImpl = messageExchangeImplBuilder.build();
        Assert.assertEquals((Object)this.consumerEndpointMock, (Object)messageExchangeImpl.getConsumerEndpoint());
        Assert.assertEquals((Object)targetEndpointMock, (Object)messageExchangeImpl.getEndpoint());
    }

    @Test
    public void testBuildUseBuilderConsumerEpForInterface() throws MessagingException {
        QName targetInterface = new QName("http://test", "interface");
        ContextualMessageExchangeImplBuilder messageExchangeImplBuilder = ContextualMessageExchangeImplBuilder.createMessageExchangeImplBuilderForInterface((ServiceEndpoint)this.consumerEndpointMock, (QName)targetInterface);
        MessageExchangeImpl messageExchangeImpl = messageExchangeImplBuilder.build();
        Assert.assertEquals((Object)this.consumerEndpointMock, (Object)messageExchangeImpl.getConsumerEndpoint());
        Assert.assertEquals((Object)targetInterface, (Object)messageExchangeImpl.getInterfaceName());
    }

    @Test
    public void testBuildUseBuilderConsumerEpForService() throws MessagingException {
        QName targetService = new QName("http://test", "service");
        ContextualMessageExchangeImplBuilder messageExchangeImplBuilder = ContextualMessageExchangeImplBuilder.createMessageExchangeImplBuilderForService((ServiceEndpoint)this.consumerEndpointMock, (QName)targetService);
        MessageExchangeImpl messageExchangeImpl = messageExchangeImplBuilder.build();
        Assert.assertEquals((Object)this.consumerEndpointMock, (Object)messageExchangeImpl.getConsumerEndpoint());
        Assert.assertEquals((Object)targetService, (Object)messageExchangeImpl.getService());
    }

    @Test
    public void testBuildGenerateUUIDExchangeId() throws MessagingException {
        ContextualMessageExchangeImplBuilder messageExchangeImplBuilder = ContextualMessageExchangeImplBuilder.createMessageExchangeImplBuilder((ServiceEndpoint)this.consumerEndpointMock);
        MessageExchangeImpl messageExchangeImpl = messageExchangeImplBuilder.build();
        String createdExchangeId = messageExchangeImpl.getExchangeId();
        this.assertIdIsPetalsQualifiedUUID(createdExchangeId);
    }

    @Test
    public void testBuildWithNonNullFlowAttributesInContext() throws MessagingException {
        FlowAttributes flowAttributes = new FlowAttributes("flowInstanceId1", "flowStepId1");
        PetalsExecutionContext.putFlowAttributes((FlowAttributes)flowAttributes);
        ContextualMessageExchangeImplBuilder messageExchangeImplBuilder = ContextualMessageExchangeImplBuilder.createMessageExchangeImplBuilder((ServiceEndpoint)this.consumerEndpointMock);
        MessageExchangeImpl actualMessageExchangeImpl = messageExchangeImplBuilder.build();
        Assert.assertEquals((Object)flowAttributes, (Object)actualMessageExchangeImpl.getFlowAttributes());
    }

    @Test
    public void testBuildWithNoFlowAttributesInContext() throws MessagingException {
        ContextualMessageExchangeImplBuilder messageExchangeImplBuilder = ContextualMessageExchangeImplBuilder.createMessageExchangeImplBuilder((ServiceEndpoint)this.consumerEndpointMock);
        MessageExchangeImpl actualMessageExchangeImpl = messageExchangeImplBuilder.build();
        Assert.assertNull((Object)actualMessageExchangeImpl.getFlowAttributes());
    }

    @Test
    public void testBuildButMissingFlowInstanceIdInContext() throws MessagingException {
        ExecutionContext.getProperties().setProperty("flowStepId", "flowStepId1");
        ContextualMessageExchangeImplBuilder messageExchangeImplBuilder = ContextualMessageExchangeImplBuilder.createMessageExchangeImplBuilder((ServiceEndpoint)this.consumerEndpointMock);
        MessageExchangeImpl actualMessageExchangeImpl = messageExchangeImplBuilder.build();
        Assert.assertNull((Object)actualMessageExchangeImpl.getFlowAttributes());
    }

    @Test
    public void testBuildButMissingFlowStepIdInContext() throws MessagingException {
        ExecutionContext.getProperties().setProperty("flowInstanceId", "flowInstanceId1");
        ContextualMessageExchangeImplBuilder messageExchangeImplBuilder = ContextualMessageExchangeImplBuilder.createMessageExchangeImplBuilder((ServiceEndpoint)this.consumerEndpointMock);
        MessageExchangeImpl actualMessageExchangeImpl = messageExchangeImplBuilder.build();
        Assert.assertNull((Object)actualMessageExchangeImpl.getFlowAttributes());
    }
}

