/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.messaging.exchange;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.ow2.petals.commons.log.FlowAttributes;
import org.ow2.petals.jbi.messaging.exchange.FaultImpl;
import org.ow2.petals.jbi.messaging.exchange.MEPPatternConstants;
import org.ow2.petals.jbi.messaging.exchange.NormalizedMessageImpl;

public class MessageExchangeImpl
implements MessageExchange,
Cloneable,
Serializable {
    @Deprecated
    public static final URI IN_ONLY_PATTERN = URI.create("http://www.w3.org/2004/08/wsdl/in-only");
    @Deprecated
    public static final URI IN_OPTIONAL_OUT_PATTERN = URI.create("http://www.w3.org/2004/08/wsdl/in-opt-out");
    @Deprecated
    public static final URI IN_OUT_PATTERN = URI.create("http://www.w3.org/2004/08/wsdl/in-out");
    @Deprecated
    public static final URI ROBUST_IN_ONLY_PATTERN = URI.create("http://www.w3.org/2004/08/wsdl/robust-in-only");
    public static final String IN_MSG = "in";
    public static final String OUT_MSG = "out";
    public static final String FAULT_MSG = "fault";
    public static final short SERIALIZE_ROLE_CONSUMER = 0;
    public static final short SERIALIZE_ROLE_PROVIDER = 1;
    public static final short SERIALIZE_STATUS_ACTIVE = 0;
    public static final short SERIALIZE_STATUS_DONE = 1;
    public static final short SERIALIZE_STATUS_ERROR = 2;
    private static final long serialVersionUID = -4354354L;
    private ServiceEndpoint consumerEndpoint;
    private ServiceEndpoint endpoint;
    private Exception error;
    private String exchangeId;
    private FlowAttributes flowAttributes;
    private QName interfaceName;
    private Map<String, NormalizedMessage> messages = new HashMap<String, NormalizedMessage>();
    private QName operation;
    private URI pattern;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private QName service;
    private boolean terminated;
    private boolean transacted;
    private boolean persisted;
    private boolean monitored;
    private transient MessageExchange.Role role = MessageExchange.Role.CONSUMER;
    private transient ExchangeStatus status = ExchangeStatus.ACTIVE;

    public void cleanMessages() {
        if (this.isDoneOrError()) {
            this.messages.clear();
        }
        if (this.messages.containsKey(FAULT_MSG) && this.messages.remove(IN_MSG) == null) {
            this.messages.remove(OUT_MSG);
        }
        if (this.messages.containsKey(OUT_MSG)) {
            this.messages.remove(IN_MSG);
        }
    }

    public Fault createFault() throws MessagingException {
        return new FaultImpl();
    }

    public NormalizedMessage createMessage() throws MessagingException {
        return new NormalizedMessageImpl();
    }

    public ServiceEndpoint getConsumerEndpoint() {
        return this.consumerEndpoint;
    }

    public ServiceEndpoint getEndpoint() {
        return this.endpoint;
    }

    public Exception getError() {
        return this.error;
    }

    public String getExchangeId() {
        return this.exchangeId;
    }

    public Fault getFault() {
        return (Fault)this.getMessage(FAULT_MSG);
    }

    public QName getInterfaceName() {
        return this.interfaceName;
    }

    public NormalizedMessage getMessage(String name) {
        if (name != null) {
            return this.messages.get(name.toLowerCase());
        }
        return null;
    }

    public Map<String, NormalizedMessage> getMessages() {
        return this.messages;
    }

    public QName getOperation() {
        return this.operation;
    }

    public URI getPattern() {
        if (this.pattern != null) {
            String version = null;
            Package _package = Package.getPackage("org.ow2.petals.cdk");
            if (_package != null) {
                version = _package.getImplementationVersion();
            }
            if (version != null && "5.1".compareTo(version) <= 0) {
                return this.pattern;
            }
            if (MEPPatternConstants.IN_ONLY.equals(this.pattern)) {
                return IN_ONLY_PATTERN;
            }
            if (MEPPatternConstants.ROBUST_IN_ONLY.equals(this.pattern)) {
                return ROBUST_IN_ONLY_PATTERN;
            }
            if (MEPPatternConstants.IN_OUT.equals(this.pattern)) {
                return IN_OUT_PATTERN;
            }
            if (MEPPatternConstants.IN_OPTIONAL_OUT.equals(this.pattern)) {
                return IN_OPTIONAL_OUT_PATTERN;
            }
        }
        return null;
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public Set<?> getPropertyNames() {
        return this.properties.keySet();
    }

    public MessageExchange.Role getRole() {
        return this.role;
    }

    public QName getService() {
        return this.service;
    }

    public ServiceEndpoint getServiceEndpoint() {
        return this.endpoint;
    }

    public ExchangeStatus getStatus() {
        return this.status;
    }

    public boolean isMonitored() {
        return this.monitored;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setConsumerEndpoint(ServiceEndpoint serviceEndpoint) {
        this.consumerEndpoint = serviceEndpoint;
    }

    public void setEndpoint(ServiceEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public void setError(Exception error) {
        if (error != null) {
            this.error = error;
            try {
                this.setStatus(ExchangeStatus.ERROR);
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
        }
    }

    public void setExchangeId(String exchangeId) {
        this.exchangeId = exchangeId;
    }

    public void setFault(Fault fault) throws MessagingException {
        this.checkIsNotTerminated();
        this.checkIsNotDoneOrError();
        this.checkCallerIsAllowedToSetFault();
        this.messages.put(FAULT_MSG, (NormalizedMessage)fault);
    }

    private void checkCallerIsAllowedToSetFault() throws MessagingException {
        if (this.isCallerActingAsConsumer() && !this.isOutResponseOfAnInOptOutExchange()) {
            throw new MessagingException("The MessageExchange state and the current Role do not allow this operation.");
        }
    }

    private boolean isCallerActingAsConsumer() {
        return MessageExchange.Role.CONSUMER.equals(this.role);
    }

    private boolean isOutResponseOfAnInOptOutExchange() {
        return IN_OPTIONAL_OUT_PATTERN.equals(this.pattern) && this.messages.containsKey(OUT_MSG);
    }

    private void checkIsNotDoneOrError() throws MessagingException {
        if (this.isDoneOrError()) {
            throw new MessagingException("The MessageExchange state and the current Role do not allow this operation.");
        }
    }

    private boolean isDoneOrError() {
        return ExchangeStatus.DONE.equals(this.status) || ExchangeStatus.ERROR.equals(this.status);
    }

    public void setInterfaceName(QName interfaceName) {
        this.interfaceName = interfaceName;
    }

    public void setMessage(NormalizedMessage msg, String name) throws MessagingException {
        this.checkIsNotTerminated();
        if (msg == null) {
            throw new MessagingException("NormalizedMessage must be non null.");
        }
        if (name == null || name.trim().length() == 0) {
            throw new MessagingException("The message reference must be non null and non empty.");
        }
        this.checkPatternMatching(name);
        this.checkRoleMatching(name);
        if (this.messages.containsKey(name.toLowerCase())) {
            throw new MessagingException("A message has already been set with the '" + name + "' reference.");
        }
        this.messages.put(name.toLowerCase(), msg);
    }

    public void setMonitored(boolean monitored) {
        this.monitored = monitored;
    }

    public void setOperation(QName name) {
        this.operation = name;
    }

    public void setPattern(URI pattern) {
        this.pattern = pattern;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    public void setProperty(String name, Object obj) {
        this.properties.put(name, obj);
    }

    public void setRole(MessageExchange.Role role) {
        this.role = role;
    }

    public void setService(QName service) {
        this.service = service;
    }

    public void setStatus(ExchangeStatus status) throws MessagingException {
        this.checkIsNotTerminated();
        if (ExchangeStatus.DONE.equals(status)) {
            if (MessageExchange.Role.CONSUMER.equals(this.role)) {
                if (IN_ONLY_PATTERN.equals(this.pattern) || MEPPatternConstants.IN_ONLY.equals(this.pattern)) {
                    throw new MessagingException("The MessageExchange state does not allow this operation.");
                }
                if ((IN_OUT_PATTERN.equals(this.pattern) || MEPPatternConstants.IN_OUT.equals(this.pattern)) && !this.messages.containsKey(FAULT_MSG) && !this.messages.containsKey(OUT_MSG)) {
                    throw new MessagingException("The MessageExchange state does not allow this operation.");
                }
                if ((IN_OPTIONAL_OUT_PATTERN.equals(this.pattern) || MEPPatternConstants.IN_OPTIONAL_OUT.equals(this.pattern)) && !this.messages.containsKey(FAULT_MSG) && !this.messages.containsKey(OUT_MSG)) {
                    throw new MessagingException("The MessageExchange state does not allow this operation.");
                }
            } else {
                if ((ROBUST_IN_ONLY_PATTERN.equals(this.pattern) || MEPPatternConstants.IN_ONLY.equals(this.pattern)) && this.messages.containsKey(FAULT_MSG)) {
                    throw new MessagingException("The MessageExchange state does not allow this operation.");
                }
                if (IN_OUT_PATTERN.equals(this.pattern) || MEPPatternConstants.IN_OUT.equals(this.pattern)) {
                    throw new MessagingException("The MessageExchange state does not allow this operation.");
                }
                if (IN_OPTIONAL_OUT_PATTERN.equals(this.pattern) || MEPPatternConstants.IN_OPTIONAL_OUT.equals(this.pattern)) {
                    if (this.messages.containsKey(FAULT_MSG) && !this.messages.containsKey(OUT_MSG)) {
                        throw new MessagingException("The MessageExchange state does not allow this operation.");
                    }
                    if (!this.messages.containsKey(FAULT_MSG) && this.messages.containsKey(OUT_MSG)) {
                        throw new MessagingException("The MessageExchange state does not allow this operation.");
                    }
                }
            }
        } else if (ExchangeStatus.ERROR.equals(status) && MessageExchange.Role.PROVIDER.equals(this.role) && (IN_OUT_PATTERN.equals(this.pattern) || MEPPatternConstants.IN_OUT.equals(this.pattern))) {
            throw new MessagingException("The MessageExchange state does not allow this operation.");
        }
        this.status = status;
    }

    public void setTerminated(boolean terminated) {
        this.terminated = terminated;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    public String toString() {
        return "MessageExchange@" + this.getExchangeId();
    }

    private void checkIsNotTerminated() throws MessagingException {
        if (this.isTerminated()) {
            throw new MessagingException("The Exchange is terminated.");
        }
    }

    private void checkPatternMatching(String name) throws MessagingException {
        if (this.pattern == null) {
            throw new MessagingException("The MEP is not defined.");
        }
        if (name == null) {
            throw new MessagingException("The reference name is not defined.");
        }
        if (IN_MSG.equalsIgnoreCase(name) && (IN_ONLY_PATTERN.equals(this.pattern) || ROBUST_IN_ONLY_PATTERN.equals(this.pattern) || IN_OUT_PATTERN.equals(this.pattern) || IN_OPTIONAL_OUT_PATTERN.equals(this.pattern) || MEPPatternConstants.IN_ONLY.equals(this.pattern) || MEPPatternConstants.ROBUST_IN_ONLY.equals(this.pattern) || MEPPatternConstants.IN_OUT.equals(this.pattern) || MEPPatternConstants.IN_OPTIONAL_OUT.equals(this.pattern))) {
            return;
        }
        if (OUT_MSG.equalsIgnoreCase(name) && (IN_OUT_PATTERN.equals(this.pattern) || IN_OPTIONAL_OUT_PATTERN.equals(this.pattern) || MEPPatternConstants.IN_OUT.equals(this.pattern) || MEPPatternConstants.IN_OPTIONAL_OUT.equals(this.pattern))) {
            return;
        }
        throw new MessagingException("the MessageExchange state does not allow this operation.");
    }

    private void checkRoleMatching(String name) throws MessagingException {
        if (this.role == null) {
            throw new MessagingException("the Role is not defined.");
        }
        if (name == null) {
            throw new MessagingException("The reference name is not defined.");
        }
        if (this.isCallerActingAsConsumer() ? IN_MSG.equalsIgnoreCase(name) : MessageExchange.Role.PROVIDER.equals(this.role) && OUT_MSG.equalsIgnoreCase(name)) {
            return;
        }
        throw new MessagingException("The Role does not allow this operation.");
    }

    private void readObject(ObjectInputStream s) throws IOException {
        switch (s.readShort()) {
            case 0: {
                this.role = MessageExchange.Role.CONSUMER;
                break;
            }
            case 1: {
                this.role = MessageExchange.Role.PROVIDER;
                break;
            }
        }
        switch (s.readShort()) {
            case 0: {
                this.status = ExchangeStatus.ACTIVE;
                break;
            }
            case 1: {
                this.status = ExchangeStatus.DONE;
                break;
            }
            case 2: {
                this.status = ExchangeStatus.ERROR;
                break;
            }
        }
        try {
            s.defaultReadObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e.getClass() + ":" + e.getMessage());
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        if (this.isCallerActingAsConsumer()) {
            s.writeShort(0);
        } else {
            s.writeShort(1);
        }
        if (ExchangeStatus.ACTIVE.equals(this.status)) {
            s.writeShort(0);
        } else if (ExchangeStatus.DONE.equals(this.status)) {
            s.writeShort(1);
        } else {
            s.writeShort(2);
        }
        s.defaultWriteObject();
    }

    public final FlowAttributes getFlowAttributes() {
        return this.flowAttributes;
    }

    public final void setFlowAttributes(FlowAttributes flowAttributes) {
        this.flowAttributes = flowAttributes;
    }
}

