/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.messaging.exchange;

import java.net.URI;
import java.util.Map;
import java.util.Set;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.ow2.petals.commons.log.FlowAttributes;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeImpl;

public class MessageExchangeWrapper
implements MessageExchange {
    protected String exchangeId;
    protected MessageExchangeImpl messageExchange;
    private MessageExchange.Role observerRole;
    private boolean timeout;

    public MessageExchangeWrapper(MessageExchangeImpl me, MessageExchange.Role observerRole) {
        assert (me != null);
        assert (observerRole != null);
        this.messageExchange = me;
        this.exchangeId = this.messageExchange.getExchangeId();
        this.observerRole = observerRole;
    }

    public Fault createFault() throws MessagingException {
        this.checkComponentOwnsExchange();
        return this.messageExchange.createFault();
    }

    public NormalizedMessage createMessage() throws MessagingException {
        this.checkComponentOwnsExchange();
        return this.messageExchange.createMessage();
    }

    public ServiceEndpoint getConsumerEndpoint() {
        return this.messageExchange.getConsumerEndpoint();
    }

    public ServiceEndpoint getEndpoint() {
        this.checkComponentOwnsExchange();
        return this.messageExchange.getEndpoint();
    }

    public Exception getError() {
        this.checkComponentOwnsExchange();
        return this.messageExchange.getError();
    }

    public String getExchangeId() {
        return this.exchangeId;
    }

    public FlowAttributes getFlowAttributes() {
        return this.messageExchange.getFlowAttributes();
    }

    public void setFlowAttributes(FlowAttributes flowAttributes) {
        this.messageExchange.setFlowAttributes(flowAttributes);
    }

    public Fault getFault() {
        this.checkComponentOwnsExchange();
        return this.messageExchange.getFault();
    }

    public QName getInterfaceName() {
        this.checkComponentOwnsExchange();
        return this.messageExchange.getInterfaceName();
    }

    public NormalizedMessage getMessage(String name) {
        this.checkComponentOwnsExchange();
        return this.messageExchange.getMessage(name);
    }

    public MessageExchangeImpl getMessageExchange() {
        return this.messageExchange;
    }

    public Map<String, NormalizedMessage> getMessages() {
        return this.messageExchange.getMessages();
    }

    public MessageExchange.Role getObserverRole() {
        return this.observerRole;
    }

    public QName getOperation() {
        this.checkComponentOwnsExchange();
        return this.messageExchange.getOperation();
    }

    public URI getPattern() {
        this.checkComponentOwnsExchange();
        return this.messageExchange.getPattern();
    }

    public Object getProperty(String name) {
        this.checkComponentOwnsExchange();
        return this.messageExchange.getProperty(name);
    }

    public Set<?> getPropertyNames() {
        this.checkComponentOwnsExchange();
        return this.messageExchange.getPropertyNames();
    }

    public MessageExchange.Role getRole() {
        return this.messageExchange.getRole();
    }

    public QName getService() {
        this.checkComponentOwnsExchange();
        return this.messageExchange.getService();
    }

    public ExchangeStatus getStatus() {
        return this.messageExchange.getStatus();
    }

    public boolean isMessageExchangeStored() {
        return this.messageExchange == null;
    }

    public boolean isTerminated() {
        return this.messageExchange.isTerminated();
    }

    public boolean isTimeout() {
        return this.timeout;
    }

    public boolean isTransacted() {
        this.checkComponentOwnsExchange();
        return this.messageExchange.isTransacted();
    }

    public void setEndpoint(ServiceEndpoint endpoint) {
        this.checkComponentOwnsExchange();
        this.messageExchange.setEndpoint(endpoint);
    }

    public void setError(Exception error) {
        this.checkComponentOwnsExchange();
        this.messageExchange.setError(error);
    }

    public void setFault(Fault fault) throws MessagingException {
        this.checkComponentOwnsExchange();
        this.messageExchange.setFault(fault);
    }

    public void setInterfaceName(QName interfaceName) {
        this.checkComponentOwnsExchange();
        this.messageExchange.setInterfaceName(interfaceName);
    }

    public void setMessage(NormalizedMessage msg, String name) throws MessagingException {
        this.checkComponentOwnsExchange();
        this.messageExchange.setMessage(msg, name);
    }

    public void setMessageExchange(MessageExchangeImpl messageExchange) throws MessagingException {
        if (!this.exchangeId.equals(messageExchange.getExchangeId())) {
            throw new MessagingException("Wrong Message Exchange Id for wrapper. Expected Id '" + this.exchangeId + "' and get '" + messageExchange.getExchangeId() + "'");
        }
        this.messageExchange = messageExchange;
    }

    public void setObserverRole(MessageExchange.Role role) {
        this.observerRole = role;
    }

    public void setOperation(QName name) {
        this.checkComponentOwnsExchange();
        this.messageExchange.setOperation(name);
    }

    public void setPersisted(boolean persisted) {
        this.messageExchange.setPersisted(persisted);
    }

    public void setProperty(String name, Object obj) {
        this.checkComponentOwnsExchange();
        this.messageExchange.setProperty(name, obj);
    }

    public void setRole(MessageExchange.Role role) {
        this.messageExchange.setRole(role);
    }

    public void setService(QName service) {
        this.checkComponentOwnsExchange();
        this.messageExchange.setService(service);
    }

    public void setStatus(ExchangeStatus status) throws MessagingException {
        this.checkComponentOwnsExchange();
        this.messageExchange.setStatus(status);
    }

    public void setTerminated(boolean terminated) {
        this.messageExchange.setTerminated(terminated);
    }

    public void setTimeout(boolean timeout) {
        this.timeout = timeout;
    }

    public void setTransacted(boolean transacted) {
        this.messageExchange.setTerminated(transacted);
    }

    private void checkComponentOwnsExchange() throws IllegalStateException {
        if (this.observerRole != null && !this.messageExchange.getRole().equals(this.observerRole)) {
            if (this.messageExchange.isTerminated()) {
                throw new IllegalStateException("The Message Exchange has been terminated by another component");
            }
            throw new IllegalStateException("The component does not owns the MessageExchange");
        }
    }
}

