/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.registry.api;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.ow2.petals.registry.api.Endpoint;

public class Resource
implements Serializable {
    private static final long serialVersionUID = -7832638254448986423L;
    private long creationTime;
    private long revision;
    private Endpoint endpoint;
    private String rootRegistry;
    private String path;
    private Map<String, String> properties;

    public Resource() {
        this(null);
    }

    public Resource(Endpoint endpoint) {
        this.endpoint = endpoint;
        this.creationTime = System.currentTimeMillis();
        this.properties = new HashMap<String, String>();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public long getRevision() {
        return this.revision;
    }

    public void setRevision(long revision) {
        this.revision = revision;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getRootRegistry() {
        return this.rootRegistry;
    }

    public void setRootRegistry(String rootRegistry) {
        this.rootRegistry = rootRegistry;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Resource [endpoint=");
        builder.append(this.endpoint);
        builder.append(", creationTime=");
        builder.append(this.creationTime);
        builder.append(", revision=");
        builder.append(this.revision);
        builder.append(", rootRegistry=");
        builder.append(this.rootRegistry);
        builder.append(", path=");
        builder.append(this.path);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.creationTime ^ this.creationTime >>> 32);
        result = 31 * result + (this.endpoint == null ? 0 : this.endpoint.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (int)(this.revision ^ this.revision >>> 32);
        result = 31 * result + (this.rootRegistry == null ? 0 : this.rootRegistry.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Resource other = (Resource)obj;
        if (this.creationTime != other.creationTime) {
            return false;
        }
        if (this.endpoint == null ? other.endpoint != null : !this.endpoint.equals(other.endpoint)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        if (this.revision != other.revision) {
            return false;
        }
        return !(this.rootRegistry == null ? other.rootRegistry != null : !this.rootRegistry.equals(other.rootRegistry));
    }
}

