/*
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package org.ow2.petals.registry.api;

import java.io.Serializable;

import javax.xml.namespace.QName;

/**
 * The endpoint definition
 *
 * @author Christophe HAMERLING - eBM WebSourcing
 * @author Charles Casadei - eBM WebSourcing
 */
public class Endpoint implements Serializable {

    private static final long serialVersionUID = -8159499352167678948L;

    /**
     * Description is a string for performance reasons.
     */
    private String description;

    /**
     * The endpoint name
     */
    private String name;

    /**
     * The service name
     */
    private QName service;

    /**
     * The interface
     */
    private QName itf;

    private String container;

    private String component;

    private String subdomain;

    private String type;

    public Endpoint() {
    }

    public String getDescription() {
        return this.description;
    }

    public QName getQName() {
        return new QName(this.name);
    }

    public void setQName(QName name) {
        this.name = name.getLocalPart();
    }

    public void setQName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setName(QName name) {
        this.name = name.getLocalPart();
    }

    /**
     * @return the service
     */
    public QName getService() {
        return this.service;
    }

    /**
     * @param service
     *            the service to set
     */
    public void setService(QName service) {
        this.service = service;
    }

    /**
     * @return the interfaces
     */
    public QName getInterface() {
        return this.itf;
    }

    /**
     * @param interfaces
     *            the interfaces to set
     */
    public void setInterface(QName itf) {
        this.itf = itf;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getContainer() {
        return this.container;
    }

    public void setContainer(String container) {
        this.container = container;
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public String getSubdomain() {
        return this.subdomain;
    }

    public void setSubdomain(String subdomain) {
        this.subdomain = subdomain;
    }
    
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Endpoint [name=");
        builder.append(this.name);
        builder.append(", service=");
        builder.append(this.service);
        builder.append(", itf=");
        builder.append(this.itf);
        builder.append(", component=");
        builder.append(this.component);
        builder.append(", container=");
        builder.append(this.container);
        builder.append(", subdomain=");
        builder.append(this.subdomain);
        // generates bad traces!
        // builder.append(", description=");
        // builder.append(this.description);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((this.component == null) ? 0 : this.component.hashCode());
        result = prime * result + ((this.container == null) ? 0 : this.container.hashCode());
        result = prime * result + ((this.description == null) ? 0 : this.description.hashCode());
        result = prime * result + ((this.itf == null) ? 0 : this.itf.hashCode());
        result = prime * result + ((this.name == null) ? 0 : this.name.hashCode());
        result = prime * result + ((this.service == null) ? 0 : this.service.hashCode());
        result = prime * result + ((this.subdomain == null) ? 0 : this.subdomain.hashCode());
        result = prime * result + ((this.type == null) ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Endpoint other = (Endpoint) obj;
        if (this.component == null) {
            if (other.component != null) {
                return false;
            }
        } else if (!this.component.equals(other.component)) {
            return false;
        }
        if (this.container == null) {
            if (other.container != null) {
                return false;
            }
        } else if (!this.container.equals(other.container)) {
            return false;
        }
        if (this.description == null) {
            if (other.description != null) {
                return false;
            }
        } else if (!this.description.equals(other.description)) {
            return false;
        }
        if (this.itf == null) {
            if (other.itf != null) {
                return false;
            }
        } else if (!this.itf.equals(other.itf)) {
            return false;
        }
        if (this.name == null) {
            if (other.name != null) {
                return false;
            }
        } else if (!this.name.equals(other.name)) {
            return false;
        }
        if (this.service == null) {
            if (other.service != null) {
                return false;
            }
        } else if (!this.service.equals(other.service)) {
            return false;
        }
        if (this.subdomain == null) {
            if (other.subdomain != null) {
                return false;
            }
        } else if (!this.subdomain.equals(other.subdomain)) {
            return false;
        }
        if (this.type == null) {
            if (other.type != null) {
                return false;
            }
        } else if (!this.type.equals(other.type)) {
            return false;
        }
        return true;
    }

}
