/*
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package org.ow2.petals.registry.api;

import org.ow2.petals.registry.api.exception.RegistryException;

/**
 * The local operations are used to manage the local registry
 * 
 * @author Christophe HAMERLING - eBM WebSourcing
 * 
 */
public interface LocalOperations {

    /**
     * Clean the local data. This operation is not propagated to other
     * containers.
     * 
     * @throws RegistryException
     */
    void clean() throws RegistryException;

    /**
     * Remove all the remote data which has been received so far... This is
     * simply because if this registry stops and then restart later, the remote
     * data may have been deleted and the local registry will not be notified
     * about that...
     */
    void cleanRemoteData() throws RegistryException;

    /**
     * Pause message reception from remote reggistries
     */
    void pauseReceive();

    /**
     * Resume message reception
     */
    void resumeReceive();

    /**
     * Synchronize the data...
     * 
     * @throws RegistryException
     */
    void synchronizeData() throws RegistryException;

}
