/**
 * PETALS - PETALS Services Platform. Copyright (c) 2008 EBM Websourcing,
 * http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package org.ow2.petals.registry.api;

import org.ow2.petals.registry.api.context.Context;
import org.ow2.petals.registry.api.exception.LifeCycleException;
import org.ow2.petals.registry.api.lifecycle.Initializable;
import org.ow2.petals.registry.api.manager.IncomingManager;
import org.ow2.petals.registry.api.manager.OutgoingManager;
import org.ow2.petals.registry.api.manager.RemoteClientManager;
import org.ow2.petals.registry.api.repository.Repository;
import org.ow2.petals.registry.api.transport.MessageReceiver;

/**
 * The local registry view. This is the central point of the registry.
 * 
 * @author Christophe HAMERLING - eBM WebSourcing
 * 
 */
public interface LocalRegistry extends Registry, Operations, LocalOperations, Initializable {

    /**
     * 
     * @return
     */
    IncomingManager getIncomingManager();

    /**
     * 
     * @param localManager
     * @throws LifeCycleException
     */
    void setIncomingManager(IncomingManager incomingManager) throws LifeCycleException;

    /**
     * 
     * @return
     */
    OutgoingManager getOutgoingManager();

    /**
     * 
     * @param remoteManager
     * @throws LifeCycleException
     */
    void setOutgoingManager(OutgoingManager outgoingManager) throws LifeCycleException;

    /**
     * 
     * @return
     */
    Repository getRepository();

    /**
     * 
     * @param repository
     * @throws LifeCycleException
     */
    void setRepository(Repository repository) throws LifeCycleException;

    /**
     * 
     * @return
     */
    Context getContext();

    /**
     * 
     * @param context
     */
    void setContext(final Context context);

    /**
     * 
     * @param messageReceiver
     */
    void setMessageReceiver(MessageReceiver messageReceiver) throws LifeCycleException;

    /**
     * 
     * @return
     */
    MessageReceiver getMessageReceiver();

    /**
     * 
     * @param remoteClientManager
     * @throws LifeCycleException
     */
    void setRemoteClientManager(RemoteClientManager remoteClientManager) throws LifeCycleException;

    /**
     * 
     * @return
     */
    RemoteClientManager getRemoteClientManager();
}
