/**
 * PETALS - PETALS Services Platform. Copyright (c) 2008 EBM Websourcing,
 * http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package org.ow2.petals.registry.api;

import java.net.URI;

import org.ow2.petals.registry.api.transport.MessageSender;

/**
 * The local view of the remote registry. When local registry (or a
 * user/developper) wants to talk to a remote one, it should use this interface
 * which hides all the communication aspects.
 * 
 * @author Christophe HAMERLING - eBM WebSourcing
 * 
 */
public interface RemoteRegistry extends Registry, RemoteOperations {
    
    /**
     * Get the remote registry URI
     * 
     * @return
     */
    URI getURI();

    /**
     * 
     * @param uri
     */
    void setURI(URI uri);

    /**
     * 
     * @return
     */
    MessageSender getMessageSender();

    /**
     * 
     * @param messageSender
     */
    void setMessageSender(MessageSender messageSender);

}
