/**
 * PETALS - PETALS Services Platform. Copyright (c) 2008 EBM Websourcing,
 * http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package org.ow2.petals.registry.api;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * The resource is the real data exchanged between registries
 *
 * @author Christophe HAMERLING - eBM WebSourcing
 *
 */
public class Resource implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = -7832638254448986423L;

    /**
     * The date creation of this resource
     */
    private long creationTime;

    /**
     * The revision is the local registry one, it is sent with the endpoint to
     * say to remote registries the current revision. If the registry which
     * receives the resource do not have the right revision (lower) it is its
     * role to accept the resource or to try to retrieve the good revision from
     * the network...
     */
    private long revision;

    /**
     * The endpoint
     */
    private Endpoint endpoint;

    /**
     * The registry which created the resource
     */
    private String rootRegistry;

    private String path;

    private Map<String, String> properties;

    /**
     * Creates a new instance of Resource
     */
    public Resource() {
        this(null);
    }

    /**
     * Creates a new instance of Resource
     *
     * @param key
     * @param data
     */
    public Resource(Endpoint endpoint) {
        this.endpoint = endpoint;
        this.creationTime = System.currentTimeMillis();
        this.properties = new HashMap<String, String>();
    }

    /**
     * @return the creationTime
     */
    public long getCreationTime() {
        return this.creationTime;
    }

    /**
     * @param creationTime
     *            the creationTime to set
     */
    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    /**
     * @return the data
     */
    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    /**
     * @param data
     *            the data to set
     */
    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    /**
     * @return the properties
     */
    public Map<String, String> getProperties() {
        return this.properties;
    }

    /**
     * @param properties
     *            the properties to set
     */
    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public long getRevision() {
        return this.revision;
    }

    public void setRevision(long revision) {
        this.revision = revision;
    }

    /**
     * @return the path
     */
    public String getPath() {
        return this.path;
    }

    /**
     * @param path
     *            the path to set
     */
    public void setPath(String path) {
        this.path = path;
    }

    /**
     * @return the rootRegistry
     */
    public String getRootRegistry() {
        return this.rootRegistry;
    }

    /**
     * @param rootRegistry the rootRegistry to set
     */
    public void setRootRegistry(String rootRegistry) {
        this.rootRegistry = rootRegistry;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Resource [endpoint=");
        builder.append(this.endpoint);
        builder.append(", creationTime=");
        builder.append(this.creationTime);
        builder.append(", revision=");
        builder.append(this.revision);
        builder.append(", rootRegistry=");
        builder.append(this.rootRegistry);
        builder.append(", path=");
        builder.append(this.path);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + (int) (this.creationTime ^ (this.creationTime >>> 32));
        result = prime * result + ((this.endpoint == null) ? 0 : this.endpoint.hashCode());
        result = prime * result + ((this.path == null) ? 0 : this.path.hashCode());
        result = prime * result + (int) (this.revision ^ (this.revision >>> 32));
        result = prime * result + ((this.rootRegistry == null) ? 0 : this.rootRegistry.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Resource other = (Resource) obj;
        if (this.creationTime != other.creationTime) {
            return false;
        }
        if (this.endpoint == null) {
            if (other.endpoint != null) {
                return false;
            }
        } else if (!this.endpoint.equals(other.endpoint)) {
            return false;
        }
        if (this.path == null) {
            if (other.path != null) {
                return false;
            }
        } else if (!this.path.equals(other.path)) {
            return false;
        }
        if (this.revision != other.revision) {
            return false;
        }
        if (this.rootRegistry == null) {
            if (other.rootRegistry != null) {
                return false;
            }
        } else if (!this.rootRegistry.equals(other.rootRegistry)) {
            return false;
        }
        return true;
    }

}
