/**
 * PETALS - PETALS Services Platform. Copyright (c) 2008 EBM Websourcing,
 * http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package org.ow2.petals.registry.api.config;

import java.util.HashMap;
import java.util.Map;

/**
 * The local node configuration. TODO : Add JNDI properties.
 * 
 * @author Christophe HAMERLING - eBM WebSourcing
 * @author Charles CASADEI - eBM WebSourcing
 */
public class Configuration {

    /**
     * Timeout on the transporter
     */
    private String registryTransportTimeout;

    /**
     * The registry synchronization period.
     */
    private String registrySynchroPeriod;

    /**
     * The registry mode
     */
    private String registryMode;

    /**
     * The remote manager class name
     */
    private String outgoingManagerClassName;

    /**
     * The local manager class name
     */
    private String incomingManagerClassName;

    /**
     * The repositoryClassName class name
     */
    private String repositoryClassName;

    /**
     * The database configuration
     */
    private DBConfiguration dbConfiguration;

    /**
     * The registry root path, used to persist data if needed
     */
    private String rootPath;

    /**
     * The local registry name
     */
    private String name;

    /**
     * The message receiver. For now there is only one message receiver, but we
     * can have more than one in the future...
     */
    private String messageReceiverClassName;

    private String messageReceiverURL;

    /**
     * The message sender class name defines the default class which is used to
     * send messages to remote hosts when it is not defined at the remote
     * regisrty level. FIXME : Use it in remote if not defined...
     */
    private String messageSenderClassName;

    /**
     * The client manager class name (may be null)
     */
    private String clientManagerClassName;

    /**
     * 
     */
    private String clientManagerURL;

    /**
     * The topology path is the URL where the topology file is stored
     */
    private String topologyFile;

    /**
     * Extensions to the default configuration, can be used by user classes.
     */
    private Map<String, String> extensions;

    /**
     * Creates a new instance of Configuration
     * 
     * @param name
     *            the registry name
     */
    public Configuration(String name) {
        this.extensions = new HashMap<String, String>();
        this.dbConfiguration = new DBConfiguration();
        this.name = name;
        this.rootPath = ".";
    }

    /**
     * @return the transporter timeout (in ms)
     */
    public String getRegistryTransportTimeout() {
        return this.registryTransportTimeout;
    }

    /**
     * @param timeout transporter timeout (in ms)
     */
    public void setRegistryTransportTimeout(final String timeout) {
        this.registryTransportTimeout = timeout;
    }

    public String getRegistrySynchroPeriod() {
        return this.registrySynchroPeriod;
    }

    public void setRegistrySynchroPeriod(final String synchroPeriod) {
        this.registrySynchroPeriod = synchroPeriod;
    }

    /**
     * @return the outgoingManagerClassName
     */
    public String getOutgoingManagerClassName() {
        return this.outgoingManagerClassName;
    }

    /**
     * @param outgoingManagerClassName
     *            the outgoingManagerClassName to set
     */
    public void setOutgoingManagerClassName(String remoteManager) {
        this.outgoingManagerClassName = remoteManager;
    }

    /**
     * @return the incomingManagerClassName
     */
    public String getIncomingManagerClassName() {
        return this.incomingManagerClassName;
    }

    /**
     * @param incomingManagerClassName
     *            the incomingManagerClassName to set
     */
    public void setIncomingManagerClassName(String localManager) {
        this.incomingManagerClassName = localManager;
    }

    /**
     * @return the repositoryClassName class name
     */
    public String getRepositoryClassName() {
        return this.repositoryClassName;
    }

    /**
     * @param repositoryClassName
     *            the repositoryClassName to set
     */
    public void setRepositoryClassName(String repository) {
        this.repositoryClassName = repository;
    }

    /**
     * @return the dbConfiguration
     */
    public DBConfiguration getDbConfiguration() {
        return this.dbConfiguration;
    }

    /**
     * @param dbConfiguration
     *            the dbConfiguration to set
     */
    public void setDbConfiguration(DBConfiguration dbConfiguration) {
        this.dbConfiguration = dbConfiguration;
    }

    /**
     * @return the extensions
     */
    public Map<String, String> getExtensions() {
        return this.extensions;
    }

    /**
     * @param extensions
     *            the extensions to set
     */
    public void setExtensions(Map<String, String> extensions) {
        this.extensions = extensions;
    }

    /**
     * @return the rootPath
     */
    public String getRootPath() {
        return this.rootPath;
    }

    /**
     * @param rootPath
     *            the rootPath to set
     */
    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    /**
     * @return the name
     */
    public String getName() {
        return this.name;
    }

    /**
     * @param name
     *            the name to set
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 
     * @return
     */
    public String getMessageReceiverClassName() {
        return this.messageReceiverClassName;
    }

    public void setMessageReceiverClassName(String messageReceiver) {
        this.messageReceiverClassName = messageReceiver;
    }

    /**
     * @return the messageReceiverURL
     */
    public String getMessageReceiverURL() {
        return this.messageReceiverURL;
    }

    /**
     * @param messageReceiverURL
     *            the messageReceiverURL to set
     */
    public void setMessageReceiverURL(String messageReceiverURL) {
        this.messageReceiverURL = messageReceiverURL;
    }

    /**
     * @return the clientManagerClassName
     */
    public String getClientManagerClassName() {
        return this.clientManagerClassName;
    }

    /**
     * @param clientManagerClassName
     *            the clientManagerClassName to set
     */
    public void setClientManagerClassName(String clientManager) {
        this.clientManagerClassName = clientManager;
    }

    /**
     * @return the clientManagerURL
     */
    public String getClientManagerURL() {
        return this.clientManagerURL;
    }

    /**
     * @param clientManagerURL
     *            the clientManagerURL to set
     */
    public void setClientManagerURL(String clientManagerURL) {
        this.clientManagerURL = clientManagerURL;
    }

    /**
     * @return the topologyPath
     */
    public String getTopologyFile() {
        return this.topologyFile;
    }

    /**
     * @param topologyPath
     *            the topologyPath to set
     */
    public void setTopologyFile(String topologyFile) {
        this.topologyFile = topologyFile;
    }

    public String getMessageSenderClassName() {
        return this.messageSenderClassName;
    }

    public void setMessageSenderClassName(String messageSenderClassName) {
        this.messageSenderClassName = messageSenderClassName;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Configuration [clientManagerClassName=");
        builder.append(this.clientManagerClassName);
        builder.append(", clientManagerURL=");
        builder.append(this.clientManagerURL);
        builder.append(", registryTransportTimeout=");
        builder.append(this.registryTransportTimeout);
        builder.append(", dbConfiguration=");
        builder.append(this.dbConfiguration);
        builder.append(", extensions=");
        builder.append(this.extensions);
        builder.append(", incomingManagerClassName=");
        builder.append(this.incomingManagerClassName);
        builder.append(", messageReceiverClassName=");
        builder.append(this.messageReceiverClassName);
        builder.append(", messageReceiverURL=");
        builder.append(this.messageReceiverURL);
        builder.append(", messageSenderClassName=");
        builder.append(this.messageSenderClassName);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", outgoingManagerClassName=");
        builder.append(this.outgoingManagerClassName);
        builder.append(", repositoryClassName=");
        builder.append(this.repositoryClassName);
        builder.append(", rootPath=");
        builder.append(this.rootPath);
        builder.append(", topologyFile=");
        builder.append(this.topologyFile);
        builder.append(", registryMode=");
        builder.append(this.registryMode);
        builder.append("]");
        return builder.toString();
    }

    public String getRegistryMode() {
        return this.registryMode;
    }

    public void setRegistryMode(String registryMode) {
        this.registryMode = registryMode;
    }
}
