/**
 * PETALS - PETALS Services Platform. Copyright (c) 2009 EBM Websourcing,
 * http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package org.ow2.petals.registry.api.config;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

/**
 * The configuration factory returns the good configuration loader from the
 * configuration type...
 * 
 * @author chamerling - eBM WebSourcing
 * 
 */
public class ConfigurationLoaderFactory {

    public enum Type {
        PROPERTIES, XML
    }

    private static Map<Type, ConfigurationLoader> loaders;

    static {
        loaders = new HashMap<Type, ConfigurationLoader>();
        loaders.put(Type.PROPERTIES, new PropertiesConfigurationLoader());
        // TODO : Add more...
    }

    public static final ConfigurationLoader getLoader(File configurationFile) {
        ConfigurationLoader loader = null;
        if ((configurationFile != null)
                && (configurationFile.getName().endsWith(".properties") || configurationFile
                        .getName().endsWith(".cfg"))) {
            loader = getLoader(Type.PROPERTIES);
        }

        return loader;
    }

    public static final ConfigurationLoader getLoader(Type type) {
        return loaders.get(type);
    }
}
