/**
 * PETALS - PETALS Services Platform. Copyright (c) 2008 EBM Websourcing,
 * http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package org.ow2.petals.registry.api.config;

/**
 * @author Christophe HAMERLING - eBM WebSourcing
 * @author Charles CASADEI - eBM WebSourcing
 */
public interface Constants {

    final String DEFAULT_LOCAL_CONFIGURATION = "org/ow2/petals/registry/api/config/default_config.properties";

    final String DEFAULT_REMOTE_CONFIGURATION = "org/ow2/petals/registry/api/config/default_remote.properties";

    // TRANSPORTER - RELATED TIMEOUTS

    final long DEFAULT_CXF_HTTP_TRANSPORTER_TIMEOUT = 10000L;

    // BASICS

    final String NAME = "registry.name";

    final String DEFAULT_MESSAGE_SENDER = "org.ow2.petals.registry.core.transport.cxf.CXFMessageSender";

    final String DEFAULT_MESSAGE_RECEIVER = "org.ow2.petals.registry.core.transport.cxf.CXFMessageReceiver";

    final String DEFAULT_INCOMING_MANAGER = "org.ow2.petals.registry.core.manager.GenericIncomingManagerImpl";

    final String DEFAULT_OUTGOING_MANAGER = "org.ow2.petals.registry.core.manager.GenericOutgoingManagerImpl";

    final String DEFAULT_REPOSITORY = "org.ow2.petals.registry.core.repository.jdbc.JDBCRepository";

    // DB

    final String DEFAULT_DB_DRIVER = "org.hsqldb.jdbcDriver";

    final String DEFAULT_DB_URL = "jdbc:hsqldb:file:registry-database01";

    final String DEFAULT_DB_DIALECT = "org.hibernate.dialect.HSQLDialect";

    final String DEFAULT_DB_USER = "SA";

    final String DEFAULT_DB_PASSWORD = "";

    final String DEFAULT_DB_CACHING_ENABLED = "false";

    final String DEFAULT_DB_C3P0_ENABLED = "false";

    // OTHERS

    public enum MODE {
        STANDALONE, PEER, MASTER, SLAVE
    }

    final String DEFAULT_REGISTRY_MODE = MODE.MASTER.toString().toLowerCase();
}
