/**
 * PETALS - PETALS Services Platform. Copyright (c) 2008 EBM Websourcing,
 * http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package org.ow2.petals.registry.api.config;

/**
 * The database configuration
 * 
 * @author Christophe HAMERLING - eBM WebSourcing
 * 
 */
public class DBConfiguration {

    private String url;

    private String username;

    private String password;

    private String driver;

    private String dialect;

    private boolean cachingEnabled;
    
    private boolean c3p0Enabled;

    /**
     * @return the username
     */
    public String getUsername() {
        return username;
    }

    /**
     * @param username
     *            the username to set
     */
    public void setUsername(String username) {
        this.username = username;
    }

    /**
     * @return the password
     */
    public String getPassword() {
        return password;
    }

    /**
     * @param password
     *            the password to set
     */
    public void setPassword(String password) {
        this.password = password;
    }

    /**
     * @return the driver
     */
    public String getDriver() {
        return driver;
    }

    /**
     * @param driver
     *            the driver to set
     */
    public void setDriver(String driver) {
        this.driver = driver;
    }

    /**
     * @return the url
     */
    public String getUrl() {
        return url;
    }

    /**
     * @param url
     *            the url to set
     */
    public void setUrl(String url) {
        this.url = url;
    }

    /**
     * @return the dialect
     */
    public String getDialect() {
        return dialect;
    }

    /**
     * @param dialect
     *            the dialect to set
     */
    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    /**
     * 
     * @return the caching configuration
     */
    public boolean isCachingEnabled() {
        return this.cachingEnabled;
    }

    /**
     * 
     * @param ehCache
     *            the caching configuration
     */
    public void setCachingEnabled(boolean cachingEnabled) {
        this.cachingEnabled = cachingEnabled;
    }

    /**
     * 
     * @return the c3p0 pooling configuration
     */
    public boolean isc3p0Enabled() {
        return this.c3p0Enabled;
    }

    /**
     * 
     * @param status
     *            the c3p0 pooling configuration
     */
    public void setc3p0Enabled(boolean status) {
        this.c3p0Enabled = status;
    }

    @Override
    public String toString() {
        return "URL : " + url + ", DRIVER : " + driver + ", USER : " + username + ", PASSWORD : "
                + password + ", DIALECT : " + dialect + ", EH_CACHE_ENABLED : " + cachingEnabled;
    }
}
