/*
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package org.ow2.petals.registry.api.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.petals.registry.api.exception.RegistryException;

import static org.ow2.petals.registry.api.config.Constants.DEFAULT_MESSAGE_SENDER;

/**
 * Load from a properties file
 * 
 * @author Christophe HAMERLING - eBM WebSourcing
 * 
 */
public class PropertiesTopologyLoader implements TopologyLoader {

    private static Log logger = LogFactory.getLog(PropertiesTopologyLoader.class);

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.ow2.petals.registry.api.config.TopologyLoader#load(java.io.InputStream
     * )
     */
    public List<RemoteConfiguration> load(InputStream is) throws RegistryException {
        if (is == null) {
            throw new RegistryException("Can not load a topology from a null input stream");
        }

        Properties props = new Properties();
        try {
            props.load(is);
        } catch (IOException e) {
            logger.warn(e.getMessage());
            throw new RegistryException("Can not load the topology file");
        }

        final List<RemoteConfiguration> result = new ArrayList<RemoteConfiguration>();

        String hosts = props.getProperty("hosts");
        List<String> list = new ArrayList<String>();
        if (hosts != null && hosts.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(hosts, ",");
            while (tokenizer.hasMoreElements()) {
                list.add(tokenizer.nextToken().trim());
            }
        }

        for (String host : list) {
            RemoteConfiguration configuration = new RemoteConfiguration(host);
            configuration.setMessageSenderClassName(props.getProperty(host + ".message.sender",
                    DEFAULT_MESSAGE_SENDER));
            configuration.setUri(props.getProperty(host + ".uri"));
            result.add(configuration);
        }

        return result;
    }

}
