/**
 * PETALS - PETALS Services Platform. Copyright (c) 2008 EBM Websourcing,
 * http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package org.ow2.petals.registry.api.config;

import java.util.HashMap;
import java.util.Map;

/**
 * The remote registry configuration
 * 
 * @author Christophe HAMERLING - eBM WebSourcing
 * 
 */
public class RemoteConfiguration {

    /**
     * The message sender class used to send messages to the remote registry
     */
    private String messageSenderClassName;

    /**
     * The remote registry name
     */
    private String name;

    /**
     * The uri of the remote registry
     */
    private String uri;

    /**
     * Some additional properties
     */
    private Map<String, String> properties;

    /**
     * Creates a new instance of RemoteConfiguration
     */
    public RemoteConfiguration(String name) {
        this.name = name;
        this.properties = new HashMap<String, String>();
    }

    public RemoteConfiguration() {
        this(null);
    }

    /**
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * @return the uri
     */
    public String getUri() {
        return uri;
    }

    /**
     * @param uri
     *            the uri to set
     */
    public void setUri(String uri) {
        this.uri = uri;
    }

    /**
     * @return the messageSenderClassName
     */
    public String getMessageSenderClassName() {
        return messageSenderClassName;
    }

    /**
     * @param messageSenderClassName
     *            the messageSenderClassName to set
     */
    public void setMessageSenderClassName(String messageSenderClassName) {
        this.messageSenderClassName = messageSenderClassName;
    }

    /**
     * @return the properties
     */
    public Map<String, String> getProperties() {
        return properties;
    }

    /**
     * @param properties
     *            the properties to set
     */
    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    /**
     * @param name
     *            the name to set
     */
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return new StringBuffer("Remote Config : sender=").append(messageSenderClassName).append(
                ", name =").append(name).append(", URI=").append(uri).toString();
    }

}
