/*
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package org.ow2.petals.registry.api.config;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

/**
 * FIXME : Not the best way to do that....
 * 
 * @author Christophe HAMERLING - eBM WebSourcing
 * 
 */
public class TopologyLoaderFactory {

    public enum Type {
        PROPERTIES, XML
    }

    private static Map<Type, TopologyLoader> loaders;

    static {
        loaders = new HashMap<Type, TopologyLoader>();
        loaders.put(Type.PROPERTIES, new PropertiesTopologyLoader());
    }

    public static final TopologyLoader getLoader(File topologyFile) {
        TopologyLoader loader = null;
        if (topologyFile != null
                && (topologyFile.getName().endsWith(".properties") || topologyFile.getName()
                        .endsWith(".cfg"))) {
            loader = getLoader(Type.PROPERTIES);
        }
        return loader;
    }

    public static final TopologyLoader getLoader(Type type) {
        return loaders.get(type);
    }

}
