/**
 * PETALS - PETALS Services Platform. Copyright (c) 2009 EBM Websourcing,
 * http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package org.ow2.petals.registry.api.context;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

import org.ow2.petals.registry.api.config.Configuration;
import org.ow2.petals.registry.api.config.ConfigurationLoader;
import org.ow2.petals.registry.api.config.ConfigurationLoaderFactory;
import org.ow2.petals.registry.api.exception.RegistryException;

/**
 * @author chamerling - eBM WebSourcing
 * 
 */
public class ContextFactory {

    private ContextFactory() {
    }

    private static ContextFactory instance;

    public static ContextFactory getInstance() {
        if (instance == null) {
            instance = new ContextFactory();
        }
        return instance;
    }

    /**
     * Creates the context from a configuration file. If the file format is
     * supported, this will load the configuration then creates the context.
     * 
     * @param registryConfigurationFile
     * @return
     * @throws RegistryException
     */
    public final Context createContext(File registryConfigurationFile) throws RegistryException {
        if ((registryConfigurationFile == null) || !registryConfigurationFile.exists()
                || registryConfigurationFile.isDirectory()) {
            throw new RegistryException("Can not load from a null configuration file");
        }

        ConfigurationLoader loader = ConfigurationLoaderFactory
                .getLoader(registryConfigurationFile);
        if (loader == null) {
            throw new RegistryException("Can not get a configuration loader for the file "
                    + registryConfigurationFile.getName());
        }

        Configuration config = null;
        try {
            config = loader.loadLocal(new FileInputStream(registryConfigurationFile));
        } catch (FileNotFoundException e) {
            throw new RegistryException(e);
        }

        return new Context(config);
    }

    public final Context createContext(Configuration configuration) throws RegistryException {
        return new Context(configuration);
    }
}
