/**
 * PETALS - PETALS Services Platform. Copyright (c) 2008 EBM Websourcing,
 * http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package org.ow2.petals.registry.api.context;

import java.io.File;

import org.ow2.petals.registry.api.exception.LifeCycleException;
import org.ow2.petals.registry.api.lifecycle.Initializable;

/**
 * The registry workspace. The registry folder tree is defined like :
 * $rootPath/registry/workspace/$registryName/repository so that multiple
 * registries woth the same rootPath can cohabit.
 * 
 * @author Christophe HAMERLING - eBM WebSourcing
 * 
 */
public class Workspace implements Initializable {

    private static final String REGISTRY = "registry";

    private static final String WORKSPACE = "workspace";

    private static final String REPOSITORY = "repository";

    /**
     * The root folder
     */
    private File root;

    /**
     * The folder where the repository stores its data
     */
    private final File repository;

    private final File registryRootPath;

    private String registryName;

    private boolean initialized;

    /**
     * Creates a new instance of Workspace
     */
    protected Workspace(File rootPath, String registryName) {
        this.initialized = false;
        this.root = rootPath;
        this.registryName = registryName;

        File reg = new File(root, REGISTRY);
        File workspace = new File(reg, WORKSPACE);
        this.registryRootPath = new File(workspace, this.registryName);
        this.repository = new File(registryRootPath, REPOSITORY);
    }

    public void init() throws LifeCycleException {
        if (isInitialized()) {
            // do not do it twice...
            return;
        }

        File rootPath = getRegistryRootPath();
        if (!rootPath.exists()) {
            if (!rootPath.mkdirs()) {
                throw new LifeCycleException("Can not create registry root path");
            }
        }

        File repoPath = getRepositoryRootPath();
        if (!repoPath.exists()) {
            if (!repoPath.mkdirs()) {
                throw new LifeCycleException("Can not create repository path");
            }
        }
        this.initialized = true;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.ow2.petals.registry.api.lifecycle.Initializable#isInitialized()
     */
    public boolean isInitialized() {
        return initialized;
    }

    /**
     * Clean the workspace
     */
    public void clean() {
        // TODO Clean the workspace
    }

    /**
     * 
     * @return
     */
    public final File getRepositoryRootPath() {
        return this.repository;
    }

    public final File getRegistryRootPath() {
        return this.registryRootPath;
    }
}
