/**
 * PETALS - PETALS Services Platform. Copyright (c) 2008 EBM Websourcing,
 * http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package org.ow2.petals.registry.api.lifecycle;

import org.ow2.petals.registry.api.context.Context;
import org.ow2.petals.registry.api.exception.LifeCycleException;

/**
 * The lifecycle interface
 * 
 * @author Christophe HAMERLING - eBM WebSourcing
 * 
 */
public interface LifeCycle {

    enum STATE {
        NOT_INITIALIZED, STARTING, STARTED, STOPPING, STOPPED, INITIALIZING, INITIALIZED, UNKNOWN,
        FAILED
    };

    /**
     * 
     * @param the
     *            context
     * @throws LifeCycleException
     */
    void init(Context context) throws LifeCycleException;

    /**
     * 
     * @throws LifeCycleException
     */
    void start() throws LifeCycleException;

    /**
     * 
     * @throws LifeCycleException
     */
    void stop() throws LifeCycleException;

    /**
     * 
     * @return
     */
    boolean isRunning();

    /**
     * 
     * @return
     */
    boolean isStarted();

    /**
     * 
     * @return
     */
    boolean isStopped();

    /**
     * 
     * @return
     */
    boolean isInitialized();

    /**
     * 
     * @return
     */
    boolean isNotInitialized();

    /**
     * 
     * @return
     */
    STATE getState();

}
