/**
 * PETALS - PETALS Services Platform. Copyright (c) 2008 EBM Websourcing,
 * http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package org.ow2.petals.registry.api.manager;

import org.ow2.petals.registry.api.LocalRegistry;
import org.ow2.petals.registry.api.RemoteOperations;
import org.ow2.petals.registry.api.exception.LifeCycleException;
import org.ow2.petals.registry.api.lifecycle.LifeCycle;

/**
 * IOManager used to manage local and remote registries
 * 
 * @author Christophe HAMERLING - eBM WebSourcing
 * 
 */
public interface IOManager extends LifeCycle, RemoteOperations {
    
    /**
     * Get the local registry which is linked to this manager
     * 
     * @return the local registry
     */
    LocalRegistry getLocalRegistry();

    /**
     * Set the local registry
     * 
     * @param localRegistry the local registry
     */
    void setLocalRegistry(LocalRegistry localRegistry) throws LifeCycleException;

}
