/*
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package org.ow2.petals.registry.api.repository;

import org.ow2.petals.registry.api.Resource;
import org.ow2.petals.registry.api.exception.RegistryException;

/**
 * The repository operations
 * 
 * @author Christophe HAMERLING - eBM WebSourcing
 * 
 */
public interface Operations extends org.ow2.petals.registry.api.Operations {

    /**
     * Delete the data of the specified registry from the repository. The
     * registry name is defined in the {@link Resource} rootRegistry field.
     * 
     * @param registryName
     * @return
     * @throws RegistryException
     */
    int deleteDataFromRegistry(String registryName) throws RegistryException;

    /**
     * Delete all the data which are not the ones from the given registry name
     * 
     * @return
     */
    int keepOnly(String registryName) throws RegistryException;

}
