/**
 * PETALS - PETALS Services Platform. Copyright (c) 2008 EBM Websourcing,
 * http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package org.ow2.petals.registry.api.repository;

import org.ow2.petals.registry.api.exception.RegistryException;

/**
 * The repository interface to be implemented to really store the resource
 * 
 * @author Christophe HAMERLING - eBM WebSourcing
 * 
 */
public interface Repository extends CoreRepository {

    /**
     * Get the repository size ie the number of entries
     */
    long size() throws RegistryException;

    /**
     * Get the number of entries under the given path
     * 
     * @param path
     * @return
     */
    long size(String path) throws RegistryException;

    /**
     * Clean the repository ie delete all the entries
     * 
     * @return the number of deleted entries
     */
    int clean() throws RegistryException;

}
