/*
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package org.ow2.petals.registry.api.transport;

import java.net.URI;

import org.ow2.petals.registry.api.RemoteOperations;

/**
 * The message sender is used to send messages to a remote registry. The
 * implementation must define how the different operations are called on the
 * remote registry and how the data is serialized.
 * 
 * @author Christophe HAMERLING - eBM WebSourcing
 * 
 */
public interface MessageSender extends RemoteOperations {

    /**
     * Get the type of message sender...
     * 
     * @return
     */
    String getType();

    /**
     * Get the URI of the remote host/service to send the message to.
     * 
     * @return
     */
    URI getURI();

    /**
     * Set the URI to send messages to
     * 
     * @param uri
     * @return
     */
    void setURI(URI uri);
}
