/**
 * PETALS - PETALS Services Platform. Copyright (c) 2008 EBM Websourcing,
 * http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package org.ow2.petals.registry.api.util;

import java.lang.reflect.Constructor;

import org.ow2.petals.registry.api.LocalRegistry;
import org.ow2.petals.registry.api.RemoteRegistry;
import org.ow2.petals.registry.api.exception.RegistryException;
import org.ow2.petals.registry.api.manager.IncomingManager;
import org.ow2.petals.registry.api.manager.OutgoingManager;
import org.ow2.petals.registry.api.manager.RemoteClientManager;
import org.ow2.petals.registry.api.repository.Repository;
import org.ow2.petals.registry.api.transport.MessageReceiver;
import org.ow2.petals.registry.api.transport.MessageSender;

/**
 * @author Christophe HAMERLING - eBM WebSourcing
 * 
 */
public class Loader {

    private Loader() {
    }

    /**
     * Load a local manager
     * 
     * @param clazz
     * @return
     * @throws RegistryException
     */
    public static final IncomingManager loadLocalManager(String clazz) throws RegistryException {
        Assert.notNull(clazz, "Local IOManager can not be null");

        IncomingManager lm = null;
        Class<?> managerClass = null;

        try {
            managerClass = Class.forName(clazz);
        } catch (ClassNotFoundException e) {
            throw new RegistryException("Couldn't load local manager class " + clazz, e);
        }

        final Class<? extends IncomingManager> subclass = managerClass.asSubclass(IncomingManager.class);
        final Constructor<? extends IncomingManager> constructor;
        try {
            constructor = subclass.getConstructor(IncomingManager.class);

            try {
                lm = constructor.newInstance();
            } catch (Exception e) {
                throw new RegistryException("Couldn't create local manager of type " + clazz, e);
            }

        } catch (NoSuchMethodException e) {
            // go with the default constructor
            try {
                lm = subclass.newInstance();
            } catch (Exception e1) {
                throw new RegistryException("Couldn't create local manager of type " + clazz, e1);
            }
        }
        return lm;
    }

    /**
     * 
     * @param config
     * @return
     * @throws RegistryException
     */
    public static final OutgoingManager loadRemoteManager(String clazz) throws RegistryException {
        Assert.notNull(clazz, "Remote IOManager can not be null");

        OutgoingManager rm = null;
        Class<?> managerClass = null;

        try {
            managerClass = Class.forName(clazz);
        } catch (ClassNotFoundException e) {
            throw new RegistryException("Couldn't load remote manager class " + clazz, e);
        }

        final Class<? extends OutgoingManager> subclass = managerClass
                .asSubclass(OutgoingManager.class);
        final Constructor<? extends OutgoingManager> constructor;
        try {
            constructor = subclass.getConstructor(OutgoingManager.class);

            try {
                rm = constructor.newInstance();
            } catch (Exception e) {
                throw new RegistryException("Couldn't create remote manager of type " + clazz, e);
            }

        } catch (NoSuchMethodException e) {
            // go with the default constructor
            try {
                rm = subclass.newInstance();
            } catch (Exception e1) {
                throw new RegistryException("Couldn't create remote manager of type " + clazz, e1);
            }
        }
        return rm;
    }

    /**
     * 
     * @param config
     * @return
     * @throws RegistryException
     */
    public static final Repository loadRepository(String clazz) throws RegistryException {
        Assert.notNull(clazz, "Repository can not be null");

        Repository r = null;
        Class<?> repoClass = null;

        try {
            repoClass = Class.forName(clazz);
        } catch (ClassNotFoundException e) {
            throw new RegistryException("Couldn't load repository class " + clazz, e);
        }

        final Class<? extends Repository> subclass = repoClass.asSubclass(Repository.class);
        final Constructor<? extends Repository> constructor;
        try {
            constructor = subclass.getConstructor(Repository.class);

            try {
                r = constructor.newInstance();
            } catch (Exception e) {
                throw new RegistryException("Couldn't create repository of type " + clazz, e);
            }

        } catch (NoSuchMethodException e) {
            // go with the default constructor
            try {
                r = subclass.newInstance();
            } catch (Exception e1) {
                throw new RegistryException("Couldn't create repository of type " + clazz, e1);
            }
        }
        return r;
    }

    /**
     * 
     * @param config
     * @return
     * @throws RegistryException
     */
    public static final LocalRegistry loadLocalRegistry(String clazz) throws RegistryException {
        Assert.notNull(clazz, "Local registry can not be null");

        LocalRegistry r = null;
        Class<?> repoClass = null;

        try {
            repoClass = Class.forName(clazz);
        } catch (ClassNotFoundException e) {
            throw new RegistryException("Couldn't load local registry class " + clazz, e);
        }

        final Class<? extends LocalRegistry> subclass = repoClass.asSubclass(LocalRegistry.class);
        final Constructor<? extends LocalRegistry> constructor;
        try {
            constructor = subclass.getConstructor(LocalRegistry.class);

            try {
                r = constructor.newInstance();
            } catch (Exception e) {
                throw new RegistryException("Couldn't create local registry of type " + clazz, e);
            }

        } catch (NoSuchMethodException e) {
            // go with the default constructor
            try {
                r = subclass.newInstance();
            } catch (Exception e1) {
                throw new RegistryException("Couldn't create local registry of type " + clazz, e1);
            }
        }
        return r;
    }

    /**
     * Load the remote registry
     * 
     * @param clazz
     * @return
     * @throws RegistryException
     */
    public static final RemoteRegistry loadRemoteRegistry(String clazz) throws RegistryException {
        Assert.notNull(clazz, "Remote registry can not be null");

        RemoteRegistry r = null;
        Class<?> repoClass = null;

        try {
            repoClass = Class.forName(clazz);
        } catch (ClassNotFoundException e) {
            throw new RegistryException("Couldn't load remote registry class " + clazz, e);
        }

        final Class<? extends RemoteRegistry> subclass = repoClass.asSubclass(RemoteRegistry.class);
        final Constructor<? extends RemoteRegistry> constructor;
        try {
            constructor = subclass.getConstructor(RemoteRegistry.class);

            try {
                r = constructor.newInstance();
            } catch (Exception e) {
                throw new RegistryException("Couldn't create remote registry of type " + clazz, e);
            }

        } catch (NoSuchMethodException e) {
            // go with the default constructor
            try {
                r = subclass.newInstance();
            } catch (Exception e1) {
                throw new RegistryException("Couldn't create remote registry of type " + clazz, e1);
            }
        }
        return r;
    }

    public static final MessageSender loadMessageSender(String clazz) throws RegistryException {
        Assert.notNull(clazz, "Message sender can not be null");

        MessageSender r = null;
        Class<?> repoClass = null;

        try {
            repoClass = Class.forName(clazz);
        } catch (ClassNotFoundException e) {
            throw new RegistryException("Couldn't load message sender class '" + clazz + "'", e);
        }

        final Class<? extends MessageSender> subclass = repoClass.asSubclass(MessageSender.class);
        final Constructor<? extends MessageSender> constructor;
        try {
            constructor = subclass.getConstructor(MessageSender.class);

            try {
                r = constructor.newInstance();
            } catch (Exception e) {
                throw new RegistryException("Couldn't create message sender of type " + clazz, e);
            }

        } catch (NoSuchMethodException e) {
            // go with the default constructor
            try {
                r = subclass.newInstance();
            } catch (Exception e1) {
                throw new RegistryException("Couldn't create message sender of type '" + clazz
                        + "'", e1);
            }
        }
        return r;
    }

    public static MessageReceiver loadMessageReceiver(String clazz) throws RegistryException {
        Assert.notNull(clazz, "Message receiver can not be null");

        MessageReceiver r = null;
        Class<?> repoClass = null;

        try {
            repoClass = Class.forName(clazz);
        } catch (ClassNotFoundException e) {
            throw new RegistryException("Couldn't load message receiver class '" + clazz + "'", e);
        }

        final Class<? extends MessageReceiver> subclass = repoClass
                .asSubclass(MessageReceiver.class);
        final Constructor<? extends MessageReceiver> constructor;
        try {
            constructor = subclass.getConstructor(MessageReceiver.class);

            try {
                r = constructor.newInstance();
            } catch (Exception e) {
                throw new RegistryException("Couldn't create message receiver of type " + clazz, e);
            }

        } catch (NoSuchMethodException e) {
            // go with the default constructor
            try {
                r = subclass.newInstance();
            } catch (Exception e1) {
                throw new RegistryException("Couldn't create message receiver of type " + clazz, e1);
            }
        }
        return r;
    }
    
    public static RemoteClientManager loadRemoteClientManager(String clazz) throws RegistryException {
        Assert.notNull(clazz, "Remote client manager can not be null");

        RemoteClientManager r = null;
        Class<?> repoClass = null;

        try {
            repoClass = Class.forName(clazz);
        } catch (ClassNotFoundException e) {
            throw new RegistryException("Couldn't load Remote client manager class '" + clazz + "'", e);
        }

        final Class<? extends RemoteClientManager> subclass = repoClass
                .asSubclass(RemoteClientManager.class);
        final Constructor<? extends RemoteClientManager> constructor;
        try {
            constructor = subclass.getConstructor(RemoteClientManager.class);

            try {
                r = constructor.newInstance();
            } catch (Exception e) {
                throw new RegistryException("Couldn't create Remote client manager of type " + clazz, e);
            }

        } catch (NoSuchMethodException e) {
            // go with the default constructor
            try {
                r = subclass.newInstance();
            } catch (Exception e1) {
                throw new RegistryException("Couldn't create Remote client manager of type " + clazz, e1);
            }
        }
        return r;
    }
}
