/**
 * PETALS - PETALS Services Platform. Copyright (c) 2009 EBM Websourcing,
 * http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package org.ow2.petals.registry.api.util;

import org.ow2.petals.registry.api.Constants;

import static org.ow2.petals.registry.api.Constants.ROOT_PATH;

/**
 * @author chamerling - eBM WebSourcing
 * 
 */
public class ResourceUtil {

    private ResourceUtil() {
    }

    /**
     * Get the file name from the resource path
     * 
     * @param path
     * @return
     */
    public static final String getResourceName(String path) {
        String result = null;
        if (ROOT_PATH.equals(path)) {
            result = ROOT_PATH;
        } else {
            String tmp = path;
            if (path.endsWith(Constants.SEPARATOR)) {
                tmp = path.substring(0, path.length() - Constants.SEPARATOR.length());
            }

            if (tmp.lastIndexOf(Constants.SEPARATOR) == 0) {
                result = tmp.substring(1, tmp.length());
            } else {
                result = tmp.substring(tmp.lastIndexOf(Constants.SEPARATOR) + 1, tmp.length());
            }
        }
        return result;
    }

    /**
     * Add the root character if not available
     * 
     * @param path
     * @return
     */
    public static final String getRealPath(String path) {
        String result = path;
        if ((result != null) && !result.startsWith(ROOT_PATH)) {
            result = ROOT_PATH + result;
        }
        return result;
    }

    /**
     * path is a directory if last character is a /
     * 
     * @param path
     * @return
     */
    public static boolean isDirectory(String path) {
        return (path != null)
                && (path.length() > 0)
                && Constants.SEPARATOR.equals(Character.valueOf(path.charAt(path.length() - 1))
                        .toString());
    }
}
