/*
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package org.ow2.petals.registry.api.ws.service;

import java.util.List;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;

import org.ow2.petals.registry.api.ws.RemoteRegistryException;
import org.ow2.petals.registry.api.ws.to.Information;
import org.ow2.petals.registry.api.ws.to.Query;
import org.ow2.petals.registry.api.ws.to.Resource;

/**
 * The registry web service used to expose the registry to other registries
 * 
 * @author Christophe HAMERLING - eBM WebSourcing
 * 
 */
@WebService
public interface RegistryService {

    @WebMethod
    boolean put(@WebParam(name = "path") String path,
            @WebParam(name = "resource") Resource resource,
            @WebParam(name = "information") Information information) throws RemoteRegistryException;

    @WebMethod
    @WebResult(name = "resource")
    Resource get(@WebParam(name = "path") String path,
            @WebParam(name = "information") Information information) throws RemoteRegistryException;

    @WebMethod
    @WebResult(name = "resource")
    List<Resource> getAll(@WebParam(name = "path") String path,
            @WebParam(name = "information") Information information) throws RemoteRegistryException;

    @WebMethod
    boolean delete(@WebParam(name = "path") String path,
            @WebParam(name = "information") Information information) throws RemoteRegistryException;

    @WebMethod
    List<Resource> query(@WebParam(name = "query") Query query,
            @WebParam(name = "information") Information information) throws RemoteRegistryException;

}
