/**
 * 
 */
package org.ow2.petals.registry.api.ws.to;

import java.util.HashMap;
import java.util.Map;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;

/**
 * @author chamerling
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(namespace = Constants.NS, name = "Query")
public class Query {
    @XmlElement(name = "endpoint")
    private QName endpoint;

    @XmlElement(name = "service")
    private QName service;

    @XmlElement(name = "interface")
    private QName itf;

    @XmlElement(name = "ignoreParams")
    private boolean ignoreParams;

    @XmlElement(name = "container")
    private String container;

    @XmlElement(name = "component")
    private String component;

    @XmlElement(name = "subdomain")
    private String subDomain;

    @XmlElement(name = "type")
    private String type;

    /**
     * others...
     */
    private Map<String, String> params;

    public Query() {
        this.params = new HashMap<String, String>();
        this.ignoreParams = true;
    }

    public QName getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(QName endpoint) {
        this.endpoint = endpoint;
    }

    public QName getService() {
        return this.service;
    }

    public void setService(QName service) {
        this.service = service;
    }

    public QName getInterface() {
        return this.itf;
    }

    public void setInterface(QName itf) {
        this.itf = itf;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public boolean isIgnoreParams() {
        return this.ignoreParams;
    }

    public void setIgnoreParams(boolean ignoreParams) {
        this.ignoreParams = ignoreParams;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Query [endpoint=");
        builder.append(this.endpoint);
        builder.append(", service=");
        builder.append(this.service);
        builder.append(", interface=");
        builder.append(this.itf);
        builder.append(", ignoreParams=");
        builder.append(this.ignoreParams);
        builder.append(", params=");
        builder.append(this.params);
        builder.append("]");
        return builder.toString();
    }

    public String getContainer() {
        return this.container;
    }

    public void setContainer(String container) {
        this.container = container;
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public String getSubDomain() {
        return this.subDomain;
    }

    public void setSubDomain(String subDomain) {
        this.subDomain = subDomain;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}
