/*
 * Copyright (c) 2009 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version. This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package org.ow2.petals.registry.api.ws.to;

import java.util.Map;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

/**
 * The resource transfer object
 * 
 * @author Christophe HAMERLING - eBM WebSourcing
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(namespace = Constants.NS, name = "Resource")
public class Resource {

    @XmlElement(name = "endpoint")
    private Endpoint endpoint;

    @XmlAttribute(name = "creationTime")
    private long creationTime;

    @XmlAttribute(name = "revision")
    private long revision;

    @XmlAttribute(name = "rootregistry")
    private String rootRegistry;

    @XmlAttribute(name = "path")
    private String path;

    // TODO : Mapper
    private Map<String, String> properties;

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    public long getRevision() {
        return this.revision;
    }

    public void setRevision(long revision) {
        this.revision = revision;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    /**
     * @return the rootRegistry
     */
    public String getRootRegistry() {
        return this.rootRegistry;
    }

    /**
     * @param rootRegistry
     *            the rootRegistry to set
     */
    public void setRootRegistry(String rootRegistry) {
        this.rootRegistry = rootRegistry;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Resource [path=");
        builder.append(this.path);
        builder.append(", creationTime=");
        builder.append(this.creationTime);
        builder.append(", properties=");
        builder.append(this.properties);
        builder.append(", revision=");
        builder.append(this.revision);
        builder.append(", rootRegistry=");
        builder.append(this.rootRegistry);
        builder.append(", endpoint=");
        builder.append(this.endpoint);
        builder.append("]");
        return builder.toString();
    }

}
