/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.registry.api.util;

import java.lang.reflect.Constructor;
import org.ow2.petals.registry.api.LocalRegistry;
import org.ow2.petals.registry.api.RemoteRegistry;
import org.ow2.petals.registry.api.exception.RegistryException;
import org.ow2.petals.registry.api.manager.IncomingManager;
import org.ow2.petals.registry.api.manager.OutgoingManager;
import org.ow2.petals.registry.api.manager.RemoteClientManager;
import org.ow2.petals.registry.api.repository.Repository;
import org.ow2.petals.registry.api.transport.MessageReceiver;
import org.ow2.petals.registry.api.transport.MessageSender;
import org.ow2.petals.registry.api.util.Assert;

public class Loader {
    private Loader() {
    }

    public static final IncomingManager loadLocalManager(String clazz) throws RegistryException {
        Assert.notNull(clazz, "Local IOManager can not be null");
        IncomingManager lm = null;
        Class<?> managerClass = null;
        try {
            managerClass = Class.forName(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new RegistryException("Couldn't load local manager class " + clazz, e);
        }
        Class<IncomingManager> subclass = managerClass.asSubclass(IncomingManager.class);
        try {
            Constructor<IncomingManager> constructor = subclass.getConstructor(IncomingManager.class);
            try {
                lm = constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RegistryException("Couldn't create local manager of type " + clazz, e);
            }
        }
        catch (NoSuchMethodException e) {
            try {
                lm = subclass.newInstance();
            }
            catch (Exception e1) {
                throw new RegistryException("Couldn't create local manager of type " + clazz, e1);
            }
        }
        return lm;
    }

    public static final OutgoingManager loadRemoteManager(String clazz) throws RegistryException {
        Assert.notNull(clazz, "Remote IOManager can not be null");
        OutgoingManager rm = null;
        Class<?> managerClass = null;
        try {
            managerClass = Class.forName(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new RegistryException("Couldn't load remote manager class " + clazz, e);
        }
        Class<OutgoingManager> subclass = managerClass.asSubclass(OutgoingManager.class);
        try {
            Constructor<OutgoingManager> constructor = subclass.getConstructor(OutgoingManager.class);
            try {
                rm = constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RegistryException("Couldn't create remote manager of type " + clazz, e);
            }
        }
        catch (NoSuchMethodException e) {
            try {
                rm = subclass.newInstance();
            }
            catch (Exception e1) {
                throw new RegistryException("Couldn't create remote manager of type " + clazz, e1);
            }
        }
        return rm;
    }

    public static final Repository loadRepository(String clazz) throws RegistryException {
        Assert.notNull(clazz, "Repository can not be null");
        Repository r = null;
        Class<?> repoClass = null;
        try {
            repoClass = Class.forName(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new RegistryException("Couldn't load repository class " + clazz, e);
        }
        Class<Repository> subclass = repoClass.asSubclass(Repository.class);
        try {
            Constructor<Repository> constructor = subclass.getConstructor(Repository.class);
            try {
                r = constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RegistryException("Couldn't create repository of type " + clazz, e);
            }
        }
        catch (NoSuchMethodException e) {
            try {
                r = subclass.newInstance();
            }
            catch (Exception e1) {
                throw new RegistryException("Couldn't create repository of type " + clazz, e1);
            }
        }
        return r;
    }

    public static final LocalRegistry loadLocalRegistry(String clazz) throws RegistryException {
        Assert.notNull(clazz, "Local registry can not be null");
        LocalRegistry r = null;
        Class<?> repoClass = null;
        try {
            repoClass = Class.forName(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new RegistryException("Couldn't load local registry class " + clazz, e);
        }
        Class<LocalRegistry> subclass = repoClass.asSubclass(LocalRegistry.class);
        try {
            Constructor<LocalRegistry> constructor = subclass.getConstructor(LocalRegistry.class);
            try {
                r = constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RegistryException("Couldn't create local registry of type " + clazz, e);
            }
        }
        catch (NoSuchMethodException e) {
            try {
                r = subclass.newInstance();
            }
            catch (Exception e1) {
                throw new RegistryException("Couldn't create local registry of type " + clazz, e1);
            }
        }
        return r;
    }

    public static final RemoteRegistry loadRemoteRegistry(String clazz) throws RegistryException {
        Assert.notNull(clazz, "Remote registry can not be null");
        RemoteRegistry r = null;
        Class<?> repoClass = null;
        try {
            repoClass = Class.forName(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new RegistryException("Couldn't load remote registry class " + clazz, e);
        }
        Class<RemoteRegistry> subclass = repoClass.asSubclass(RemoteRegistry.class);
        try {
            Constructor<RemoteRegistry> constructor = subclass.getConstructor(RemoteRegistry.class);
            try {
                r = constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RegistryException("Couldn't create remote registry of type " + clazz, e);
            }
        }
        catch (NoSuchMethodException e) {
            try {
                r = subclass.newInstance();
            }
            catch (Exception e1) {
                throw new RegistryException("Couldn't create remote registry of type " + clazz, e1);
            }
        }
        return r;
    }

    public static final MessageSender loadMessageSender(String clazz) throws RegistryException {
        Assert.notNull(clazz, "Message sender can not be null");
        MessageSender r = null;
        Class<?> repoClass = null;
        try {
            repoClass = Class.forName(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new RegistryException("Couldn't load message sender class '" + clazz + "'", e);
        }
        Class<MessageSender> subclass = repoClass.asSubclass(MessageSender.class);
        try {
            Constructor<MessageSender> constructor = subclass.getConstructor(MessageSender.class);
            try {
                r = constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RegistryException("Couldn't create message sender of type " + clazz, e);
            }
        }
        catch (NoSuchMethodException e) {
            try {
                r = subclass.newInstance();
            }
            catch (Exception e1) {
                throw new RegistryException("Couldn't create message sender of type '" + clazz + "'", e1);
            }
        }
        return r;
    }

    public static MessageReceiver loadMessageReceiver(String clazz) throws RegistryException {
        Assert.notNull(clazz, "Message receiver can not be null");
        MessageReceiver r = null;
        Class<?> repoClass = null;
        try {
            repoClass = Class.forName(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new RegistryException("Couldn't load message receiver class '" + clazz + "'", e);
        }
        Class<MessageReceiver> subclass = repoClass.asSubclass(MessageReceiver.class);
        try {
            Constructor<MessageReceiver> constructor = subclass.getConstructor(MessageReceiver.class);
            try {
                r = constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RegistryException("Couldn't create message receiver of type " + clazz, e);
            }
        }
        catch (NoSuchMethodException e) {
            try {
                r = subclass.newInstance();
            }
            catch (Exception e1) {
                throw new RegistryException("Couldn't create message receiver of type " + clazz, e1);
            }
        }
        return r;
    }

    public static RemoteClientManager loadRemoteClientManager(String clazz) throws RegistryException {
        Assert.notNull(clazz, "Remote client manager can not be null");
        RemoteClientManager r = null;
        Class<?> repoClass = null;
        try {
            repoClass = Class.forName(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new RegistryException("Couldn't load Remote client manager class '" + clazz + "'", e);
        }
        Class<RemoteClientManager> subclass = repoClass.asSubclass(RemoteClientManager.class);
        try {
            Constructor<RemoteClientManager> constructor = subclass.getConstructor(RemoteClientManager.class);
            try {
                r = constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RegistryException("Couldn't create Remote client manager of type " + clazz, e);
            }
        }
        catch (NoSuchMethodException e) {
            try {
                r = subclass.newInstance();
            }
            catch (Exception e1) {
                throw new RegistryException("Couldn't create Remote client manager of type " + clazz, e1);
            }
        }
        return r;
    }
}

