/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.registry.api.context;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ow2.petals.registry.api.config.Configuration;
import org.ow2.petals.registry.api.config.RemoteConfiguration;
import org.ow2.petals.registry.api.config.TopologyLoader;
import org.ow2.petals.registry.api.config.TopologyLoaderFactory;
import org.ow2.petals.registry.api.context.Workspace;
import org.ow2.petals.registry.api.exception.LifeCycleException;
import org.ow2.petals.registry.api.exception.RegistryException;
import org.ow2.petals.registry.api.lifecycle.Initializable;
import org.ow2.petals.registry.api.util.Assert;

public class Context
implements Initializable {
    private static Log log = LogFactory.getLog(Context.class);
    private final Configuration configuration;
    private List<RemoteConfiguration> topology;
    private final Workspace workspace;
    private boolean initialized;
    private static Map<String, Context> instances = new HashMap<String, Context>();
    private final Map<String, Object> properties;

    public static synchronized void store(Context context) {
        Assert.notNull(context);
        Assert.notNull(context.getConfiguration());
        Assert.notNull(context.getConfiguration().getName());
        instances.put(context.getConfiguration().getName(), context);
    }

    public static Context getContext(String registryName) {
        return instances.get(registryName);
    }

    public Context(Configuration configuration) throws RegistryException {
        Assert.notNull(configuration);
        this.properties = new HashMap<String, Object>();
        this.topology = new ArrayList<RemoteConfiguration>();
        this.configuration = configuration;
        File home = null;
        String rootPath = configuration.getRootPath();
        if (rootPath == null || rootPath.trim().length() == 0) {
            rootPath = System.getProperty("org.ow2.registry.REGISTRY_HOME");
            if (rootPath == null) {
                String pwd = null;
                try {
                    pwd = new File(".").getCanonicalPath();
                }
                catch (IOException e1) {
                    pwd = new File(".").getAbsolutePath();
                }
                home = new File(pwd);
            } else {
                home = new File(rootPath);
            }
        } else {
            home = new File(rootPath);
        }
        configuration.setRootPath(home.getAbsolutePath());
        if (log.isInfoEnabled()) {
            log.debug((Object)("Loading with config : " + configuration.toString()));
        }
        if (configuration.getTopologyFile() != null) {
            File config = new File(configuration.getTopologyFile());
            if (config.exists()) {
                TopologyLoader loader = TopologyLoaderFactory.getLoader(config);
                if (loader != null) {
                    try {
                        this.topology.addAll(loader.load(new FileInputStream(config)));
                    }
                    catch (FileNotFoundException e) {
                        log.warn((Object)e.getMessage());
                    }
                    catch (RegistryException e) {
                        log.warn((Object)e.getMessage());
                    }
                }
            } else {
                throw new RegistryException("Can not find specified topology file " + configuration.getTopologyFile());
            }
        }
        this.workspace = new Workspace(new File(configuration.getRootPath()), configuration.getName());
        Context.store(this);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public boolean isLoaded() {
        return this.initialized;
    }

    @Override
    public void init() throws LifeCycleException {
        this.workspace.init();
        Context.store(this);
        this.initialized = true;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public List<RemoteConfiguration> getTopology() {
        return this.topology;
    }

    public void setTopology(List<RemoteConfiguration> topology) {
        this.topology = topology;
    }
}

