/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.regulation;

import java.io.File;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.ow2.petals.regulation.RegulationException;
import org.ow2.petals.regulation.generated.Regulation;
import org.xml.sax.SAXException;

public final class RegulationBuilder {
    public static final String NAMESPACE_XSD = "http://www.w3.org/2001/XMLSchema";
    public static final String REGULATION_XSD = "petalsRegulation.xsd";
    private static Unmarshaller unmarshaller;
    private static RegulationException unmarshCreationEx;
    private static Marshaller marshaller;
    private static RegulationException marshallerCreationEx;

    private RegulationBuilder() {
    }

    public static Regulation createRegulation(String string) throws RegulationException {
        return RegulationBuilder.createRegulation(new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Regulation createRegulation(File file) throws RegulationException {
        if (unmarshaller == null) {
            throw unmarshCreationEx;
        }
        try {
            JAXBElement jAXBElement;
            Unmarshaller unmarshaller = RegulationBuilder.unmarshaller;
            synchronized (unmarshaller) {
                jAXBElement = RegulationBuilder.unmarshaller.unmarshal((Source)new StreamSource(file), Regulation.class);
            }
            return (Regulation)jAXBElement.getValue();
        }
        catch (JAXBException jAXBException) {
            throw new RegulationException("Failed to build Regulation", (Exception)((Object)jAXBException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String buildXmlStringRegulation(Regulation regulation) throws RegulationException {
        if (marshaller == null) {
            throw marshallerCreationEx;
        }
        try {
            StringWriter stringWriter = new StringWriter();
            Marshaller marshaller = RegulationBuilder.marshaller;
            synchronized (marshaller) {
                RegulationBuilder.marshaller.marshal((Object)regulation, (Writer)stringWriter);
            }
            return stringWriter.toString();
        }
        catch (JAXBException jAXBException) {
            throw new RegulationException("Failed to build XML binding from Regulation Java classes", (Exception)((Object)jAXBException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void buildXmlFileRegulation(Regulation regulation, File file) throws RegulationException {
        if (marshaller == null) {
            throw marshallerCreationEx;
        }
        try {
            Marshaller marshaller = RegulationBuilder.marshaller;
            synchronized (marshaller) {
                RegulationBuilder.marshaller.marshal((Object)regulation, file);
            }
        }
        catch (JAXBException jAXBException) {
            throw new RegulationException("Failed to build XML binding from Regulation Java classes", (Exception)((Object)jAXBException));
        }
    }

    static {
        marshaller = null;
        marshallerCreationEx = null;
        InputStream inputStream = RegulationBuilder.class.getResourceAsStream("/petalsRegulation.xsd");
        try {
            JAXBContext jAXBContext;
            SchemaFactory schemaFactory = SchemaFactory.newInstance(NAMESPACE_XSD);
            Source[] sourceArray = new StreamSource[]{new StreamSource(inputStream)};
            Schema schema = schemaFactory.newSchema(sourceArray);
            try {
                jAXBContext = JAXBContext.newInstance((Class[])new Class[]{Regulation.class});
                unmarshaller = jAXBContext.createUnmarshaller();
                unmarshaller.setSchema(schema);
            }
            catch (JAXBException jAXBException) {
                unmarshCreationEx = new RegulationException("Failed to create the JAXB unmarshaller", (Exception)((Object)jAXBException));
            }
            try {
                jAXBContext = JAXBContext.newInstance((Class[])new Class[]{Regulation.class});
                marshaller = jAXBContext.createMarshaller();
                marshaller.setSchema(schema);
            }
            catch (JAXBException jAXBException) {
                marshallerCreationEx = new RegulationException("Failed to create the JAXB marshaller", (Exception)((Object)jAXBException));
            }
        }
        catch (SAXException sAXException) {
            RegulationException regulationException = new RegulationException("Failed to parse resource 'petalsRegulation.xsd'", sAXException);
            unmarshCreationEx = new RegulationException("Failed to create the JAXB unmarshaller", regulationException);
            marshallerCreationEx = new RegulationException("Failed to create the JAXB marshaller", regulationException);
        }
    }
}

