/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.tools.rmi.common.serializable;

import com.ebmwebsourcing.easycommons.xml.SourceHelper;
import com.ebmwebsourcing.easycommons.xml.XMLComparator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import junit.framework.TestCase;
import org.objectweb.petals.tools.rmi.common.serializable.NormalizedMessage;

public class NormalizedMessageTest
extends TestCase {
    private static final String XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><source><title>XSL</title><author>John Smith</author></source>";

    private static final String getTestXmlContent(int padLength) {
        int padChar = 45;
        StringBuffer sb = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?><source>");
        for (int i = 0; i < padLength; ++i) {
            sb.append('-');
        }
        sb.append("</source>");
        return sb.toString();
    }

    private void testWriteReadObjectDelegateOfNormalizedMessageContent(String testXmlContent) throws Exception {
        NormalizedMessage outputedNM = new NormalizedMessage();
        outputedNM.setContent((Source)new StreamSource(new ByteArrayInputStream(testXmlContent.getBytes())));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(outputedNM);
        oos.close();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
        NormalizedMessage inputedNM = (NormalizedMessage)ois.readObject();
        ois.close();
        TestCase.assertTrue((String)"Both normalized message must be equals", (boolean)XMLComparator.isEquivalent((String)SourceHelper.toString((Source)inputedNM.getContent()), (String)testXmlContent));
    }

    public void testWriteReadObjectDelegateOfNormalizedMessageContentSimpleXmlContent() throws Exception {
        this.testWriteReadObjectDelegateOfNormalizedMessageContent(XML);
    }

    public void testWriteReadObjectDelegateOfNormalizedMessageContentXmlContentOfVariousSize() throws Exception {
        for (int i = 0; i < 10240; ++i) {
            this.testWriteReadObjectDelegateOfNormalizedMessageContent(NormalizedMessageTest.getTestXmlContent(i));
        }
    }
}

