/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.petals.tools.rmi.common.serializable;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.objectweb.petals.tools.rmi.common.serializable.Fault;
import org.objectweb.petals.tools.rmi.common.serializable.NormalizedMessage;

public class MessageExchange
implements javax.jbi.messaging.MessageExchange,
Cloneable,
Serializable {
    private static final long serialVersionUID = -3551387L;
    public static final String IN_MSG = "in";
    public static final URI IN_ONLY_PATTERN = URI.create("http://www.w3.org/2004/08/wsdl/in-only");
    public static final URI IN_OPTIONAL_OUT_PATTERN = URI.create("http://www.w3.org/2004/08/wsdl/in-opt-out");
    public static final URI IN_OUT_PATTERN = URI.create("http://www.w3.org/2004/08/wsdl/in-out");
    public static final String OUT_MSG = "out";
    public static final URI ROBUST_IN_ONLY_PATTERN = URI.create("http://www.w3.org/2004/08/wsdl/robust-in-only");
    private static final short SERIALIZE_ROLE_CONSUMER = 0;
    private static final short SERIALIZE_ROLE_PROVIDER = 1;
    private static final short SERIALIZE_STATUS_ACTIVE = 0;
    private static final short SERIALIZE_STATUS_DONE = 1;
    private static final short SERIALIZE_STATUS_ERROR = 2;
    private URI pattern;
    private ServiceEndpoint endpoint;
    private Exception error;
    private String exchangeId;
    private String processInstanceId;
    private javax.jbi.messaging.Fault fault;
    private QName interfaceName;
    private Map<String, javax.jbi.messaging.NormalizedMessage> messages = new HashMap<String, javax.jbi.messaging.NormalizedMessage>();
    private QName operation;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private transient MessageExchange.Role role;
    private QName service;
    private transient ExchangeStatus status = ExchangeStatus.ACTIVE;
    private boolean transacted;

    public MessageExchange() {
        this.role = MessageExchange.Role.CONSUMER;
    }

    public javax.jbi.messaging.Fault createFault() throws MessagingException {
        return new Fault();
    }

    public javax.jbi.messaging.NormalizedMessage createMessage() throws MessagingException {
        return new NormalizedMessage();
    }

    public ServiceEndpoint getEndpoint() {
        return this.endpoint;
    }

    public Exception getError() {
        return this.error;
    }

    public String getExchangeId() {
        return this.exchangeId;
    }

    public javax.jbi.messaging.Fault getFault() {
        return this.fault;
    }

    public QName getInterfaceName() {
        return this.interfaceName;
    }

    public javax.jbi.messaging.NormalizedMessage getMessage(String name) {
        javax.jbi.messaging.NormalizedMessage msg = null;
        msg = name != null ? this.messages.get(name.toLowerCase()) : null;
        return msg;
    }

    public QName getOperation() {
        return this.operation;
    }

    public URI getPattern() {
        return this.pattern;
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public Set<?> getPropertyNames() {
        return this.properties.keySet();
    }

    public MessageExchange.Role getRole() {
        return this.role;
    }

    public QName getService() {
        return this.service;
    }

    public ExchangeStatus getStatus() {
        return this.status;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setEndpoint(ServiceEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public void setError(Exception error) {
        this.error = error;
        this.status = ExchangeStatus.ERROR;
        this.messages.clear();
    }

    public void setFault(javax.jbi.messaging.Fault fault) throws MessagingException {
        this.fault = fault;
        this.messages.clear();
    }

    public void setInterfaceName(QName interfaceName) {
        this.interfaceName = interfaceName;
    }

    public void setMessage(javax.jbi.messaging.NormalizedMessage msg, String name) throws MessagingException {
        if (msg == null) {
            throw new MessagingException("NormalizedMessage must be non null.");
        }
        if (name == null || name.trim().length() == 0) {
            throw new MessagingException("The message reference must be non null and non empty.");
        }
        this.messages.put(name.toLowerCase(), msg);
    }

    public void setOperation(QName name) {
        this.operation = name;
    }

    public void setProperty(String name, Object obj) {
        this.properties.put(name, obj);
    }

    public void setService(QName service) {
        this.service = service;
    }

    public void setStatus(ExchangeStatus status) throws MessagingException {
        this.status = status;
        if (this.status != ExchangeStatus.ACTIVE) {
            this.messages.clear();
        }
    }

    public void setExchangeId(String id) {
        this.exchangeId = id;
    }

    public void setPattern(URI p) {
        this.pattern = p;
    }

    public void setRole(MessageExchange.Role r) {
        this.role = r;
    }

    public Map<String, javax.jbi.messaging.NormalizedMessage> getMessages() {
        return this.messages;
    }

    protected void readObjectDelegate(ObjectInputStream s) throws IOException {
        short roleTemp = s.readShort();
        short statusTemp = s.readShort();
        if (roleTemp == 0) {
            this.role = MessageExchange.Role.CONSUMER;
        } else if (roleTemp == 1) {
            this.role = MessageExchange.Role.PROVIDER;
        }
        if (statusTemp == 0) {
            this.status = ExchangeStatus.ACTIVE;
        } else if (statusTemp == 1) {
            this.status = ExchangeStatus.DONE;
        } else if (statusTemp == 2) {
            this.status = ExchangeStatus.ERROR;
        }
        try {
            s.defaultReadObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e.getClass() + ":" + e.getMessage());
        }
    }

    protected void writeObjectDelegate(ObjectOutputStream s) throws IOException {
        if (MessageExchange.Role.CONSUMER.equals(this.role)) {
            s.writeShort(0);
        } else {
            s.writeShort(1);
        }
        if (ExchangeStatus.ACTIVE.equals(this.status)) {
            s.writeShort(0);
        } else if (ExchangeStatus.DONE.equals(this.status)) {
            s.writeShort(1);
        } else {
            s.writeShort(2);
        }
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException {
        this.readObjectDelegate(s);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.writeObjectDelegate(s);
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }
}

