/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.petals.tools.rmi.server.remote.implementations;

import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.management.MBeanServer;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.objectweb.petals.tools.rmi.common.serializable.MBeanNames;
import org.objectweb.petals.tools.rmi.server.remote.interfaces.RemoteComponentContext;
import org.objectweb.petals.tools.rmi.server.remote.interfaces.RemoteDeliveryChannel;
import org.objectweb.petals.tools.rmi.server.util.Convert;
import org.ow2.easywsdl.wsdl.WSDLFactory;
import org.ow2.easywsdl.wsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.Endpoint;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.Service;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.WSDLWriter;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfEndpoint;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfInterfaceType;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfService;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.xml.sax.SAXException;

public class RemoteComponentContextImpl
extends UnicastRemoteObject
implements RemoteComponentContext {
    private static final long serialVersionUID = 7288972323223181501L;
    private ComponentContext componentContext;
    private RemoteDeliveryChannel rmiDeliveryChannel;
    private javax.jbi.management.MBeanNames mbeanNames;
    private Map<String, Document> wsdlMap;
    private static WSDLFactory wsdlFactory;
    private static WSDLWriter wsdlWriter;

    public RemoteComponentContextImpl(ComponentContext c, RemoteDeliveryChannel dl) throws RemoteException {
        this.componentContext = c;
        this.rmiDeliveryChannel = dl;
        this.wsdlMap = new ConcurrentHashMap<String, Document>();
        this.mbeanNames = new MBeanNames(this.componentContext.getMBeanNames().getJmxDomainName());
    }

    @Override
    public ServiceEndpoint activateEndpoint(QName interfaceName, QName serviceName, String endpointName) throws JBIException, RemoteException {
        try {
            this.wsdlMap.put(endpointName, this.generateWSDL(interfaceName, serviceName, endpointName));
            ServiceEndpoint se = this.componentContext.activateEndpoint(serviceName, endpointName);
            this.componentContext.getLogger("rmi-server", null).fine("New Service Endpoint deployed: " + se);
            return new org.objectweb.petals.tools.rmi.common.serializable.ServiceEndpoint(se.getServiceName(), se.getEndpointName(), se.getInterfaces());
        }
        catch (JBIException e) {
            throw Convert.convertJBIException(e);
        }
        catch (WSDLException e) {
            RemoteException exception = new RemoteException("Error occured during the WSDL generation");
            exception.setStackTrace(e.getStackTrace());
            throw exception;
        }
        catch (SAXException e) {
            RemoteException exception = new RemoteException("Error occured during the WSDL generation");
            exception.setStackTrace(e.getStackTrace());
            throw exception;
        }
        catch (IOException e) {
            RemoteException exception = new RemoteException("Error occured during the WSDL generation");
            exception.setStackTrace(e.getStackTrace());
            throw exception;
        }
        catch (ParserConfigurationException e) {
            RemoteException exception = new RemoteException("Error occured during the WSDL generation");
            exception.setStackTrace(e.getStackTrace());
            throw exception;
        }
        catch (TransformerException e) {
            RemoteException exception = new RemoteException("Error occured during the WSDL generation");
            exception.setStackTrace(e.getStackTrace());
            throw exception;
        }
    }

    @Override
    public void deactivateEndpoint(ServiceEndpoint endpoint) throws JBIException, RemoteException {
        try {
            ServiceEndpoint se = this.componentContext.getEndpoint(endpoint.getServiceName(), endpoint.getEndpointName());
            this.componentContext.deactivateEndpoint(se);
            this.wsdlMap.remove(endpoint.getEndpointName());
        }
        catch (JBIException e) {
            throw Convert.convertJBIException(e);
        }
        finally {
            this.wsdlMap.remove(endpoint.getEndpointName());
        }
    }

    @Override
    public void deregisterExternalEndpoint(ServiceEndpoint externalEndpoint) throws JBIException, RemoteException {
        throw new NoSuchMethodError("deregisterExternalEndpoint: Not implemented.");
    }

    @Override
    public String getComponentName() throws RemoteException {
        return this.componentContext.getComponentName();
    }

    @Override
    public RemoteDeliveryChannel getDeliveryChannel() throws MessagingException, RemoteException {
        return this.rmiDeliveryChannel;
    }

    @Override
    public ServiceEndpoint getEndpoint(QName service, String name) throws RemoteException {
        ServiceEndpoint seC = this.componentContext.getEndpoint(service, name);
        org.objectweb.petals.tools.rmi.common.serializable.ServiceEndpoint seF = null;
        if (seC != null) {
            seF = new org.objectweb.petals.tools.rmi.common.serializable.ServiceEndpoint(seC.getServiceName(), seC.getEndpointName(), seC.getInterfaces());
        }
        return seF;
    }

    @Override
    public Document getEndpointDescriptor(ServiceEndpoint endpoint) throws JBIException, RemoteException {
        Document doc = null;
        ServiceEndpoint se = this.componentContext.getEndpoint(endpoint.getServiceName(), endpoint.getEndpointName());
        if (se != null) {
            doc = this.componentContext.getEndpointDescriptor(se);
        }
        return doc;
    }

    @Override
    public ServiceEndpoint[] getEndpoints(QName interfaceName) throws RemoteException {
        ServiceEndpoint[] sesTemp = this.componentContext.getEndpoints(interfaceName);
        ServiceEndpoint[] sesRes = null;
        if (sesTemp != null) {
            sesRes = new ServiceEndpoint[sesTemp.length];
            for (int i = 0; i < sesRes.length; ++i) {
                sesRes[i] = new org.objectweb.petals.tools.rmi.common.serializable.ServiceEndpoint(sesTemp[i].getServiceName(), sesTemp[i].getEndpointName(), sesTemp[i].getInterfaces());
            }
        }
        return sesRes;
    }

    @Override
    public ServiceEndpoint[] getEndpointsForService(QName serviceName) throws RemoteException {
        ServiceEndpoint[] sesTemp = this.componentContext.getEndpointsForService(serviceName);
        ServiceEndpoint[] sesRes = null;
        if (sesTemp != null) {
            sesRes = new ServiceEndpoint[sesTemp.length];
            for (int i = 0; i < sesRes.length; ++i) {
                sesRes[i] = new org.objectweb.petals.tools.rmi.common.serializable.ServiceEndpoint(sesTemp[i].getServiceName(), sesTemp[i].getEndpointName(), sesTemp[i].getInterfaces());
            }
        }
        return sesRes;
    }

    @Override
    public ServiceEndpoint[] getExternalEndpoints(QName interfaceName) throws RemoteException {
        ServiceEndpoint[] sesTemp = this.componentContext.getExternalEndpoints(interfaceName);
        ServiceEndpoint[] sesRes = null;
        if (sesTemp != null) {
            sesRes = new ServiceEndpoint[sesTemp.length];
            for (int i = 0; i < sesRes.length; ++i) {
                sesRes[i] = new org.objectweb.petals.tools.rmi.common.serializable.ServiceEndpoint(sesTemp[i].getServiceName(), sesTemp[i].getEndpointName(), sesTemp[i].getInterfaces());
            }
        }
        return sesRes;
    }

    @Override
    public ServiceEndpoint[] getExternalEndpointsForService(QName serviceName) throws RemoteException {
        ServiceEndpoint[] sesTemp = this.componentContext.getExternalEndpointsForService(serviceName);
        ServiceEndpoint[] sesRes = null;
        if (sesTemp != null) {
            sesRes = new ServiceEndpoint[sesTemp.length];
            for (int i = 0; i < sesRes.length; ++i) {
                sesRes[i] = new org.objectweb.petals.tools.rmi.common.serializable.ServiceEndpoint(sesTemp[i].getServiceName(), sesTemp[i].getEndpointName(), sesTemp[i].getInterfaces());
            }
        }
        return sesRes;
    }

    @Override
    public String getInstallRoot() throws RemoteException {
        return this.componentContext.getInstallRoot();
    }

    @Override
    public Logger getLogger(String suffix, String resourceBundleName) throws JBIException, RemoteException {
        throw new NoSuchMethodError("getLogger: Not implemented.");
    }

    @Override
    public javax.jbi.management.MBeanNames getMBeanNames() throws RemoteException {
        return this.mbeanNames;
    }

    @Override
    public MBeanServer getMBeanServer() throws RemoteException {
        throw new NoSuchMethodError("getMBeanServer: Not implemented.");
    }

    @Override
    public InitialContext getNamingContext() throws RemoteException {
        throw new NoSuchMethodError("getNamingContext: Not implemented.");
    }

    @Override
    public Object getTransactionManager() throws RemoteException {
        throw new NoSuchMethodError("getTransactionManager: Not implemented.");
    }

    @Override
    public String getWorkspaceRoot() throws RemoteException {
        return this.componentContext.getWorkspaceRoot();
    }

    @Override
    public void registerExternalEndpoint(ServiceEndpoint externalEndpoint) throws JBIException, RemoteException {
        throw new NoSuchMethodError("registerExternalEndpoint: Not implemented.");
    }

    @Override
    public ServiceEndpoint resolveEndpointReference(DocumentFragment epr) throws RemoteException {
        ServiceEndpoint seC = this.componentContext.resolveEndpointReference(epr);
        org.objectweb.petals.tools.rmi.common.serializable.ServiceEndpoint seF = null;
        if (seC != null) {
            seF = new org.objectweb.petals.tools.rmi.common.serializable.ServiceEndpoint(seC.getServiceName(), seC.getEndpointName(), seC.getInterfaces());
        }
        return seF;
    }

    public Document getOwnedEndpointDescriptor(String endpointName) {
        return this.wsdlMap.get(endpointName);
    }

    private Document generateWSDL(QName interfaceName, QName serviceName, String endpointName) throws WSDLException, SAXException, IOException, ParserConfigurationException, TransformerException {
        Description description = RemoteComponentContextImpl.getWSDLFactory().newDescription(AbsItfDescription.WSDLVersionConstants.WSDL20);
        description.setTargetNamespace(serviceName.getNamespaceURI());
        Service service = (Service)description.createService();
        service.setQName(serviceName);
        InterfaceType _interface = (InterfaceType)description.createInterface();
        _interface.setQName(interfaceName);
        Endpoint endpoint = (Endpoint)service.createEndpoint();
        endpoint.setName(endpointName);
        service.addEndpoint((AbsItfEndpoint)endpoint);
        service.setInterface((AbsItfInterfaceType)_interface);
        description.addService((AbsItfService)service);
        description.addInterface((AbsItfInterfaceType)_interface);
        return RemoteComponentContextImpl.getWSDLWriter().getDocument(description);
    }

    private static final synchronized WSDLFactory getWSDLFactory() throws WSDLException {
        if (wsdlFactory == null) {
            wsdlFactory = WSDLFactory.newInstance();
        }
        return wsdlFactory;
    }

    private static final synchronized WSDLWriter getWSDLWriter() throws WSDLException {
        if (wsdlWriter == null) {
            wsdlWriter = RemoteComponentContextImpl.getWSDLFactory().newWSDLWriter();
        }
        return wsdlWriter;
    }
}

