/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.engine.sampleclient;

import com.ebmwebsourcing.easycommons.xml.XMLHelper;
import com.ebmwebsourcing.wsstar.addressing.definition.impl.Constants;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.jbi.JBIException;
import javax.jbi.component.Component;
import javax.jbi.component.ComponentContext;
import javax.jbi.component.ComponentLifeCycle;
import javax.jbi.component.ServiceUnitManager;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOptionalOut;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.messaging.RobustInOnly;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import org.ow2.petals.component.framework.util.JVMDocumentBuilders;
import org.ow2.petals.engine.sampleclient.SampleClientListener;
import org.ow2.petals.engine.sampleclient.Utils;
import org.ow2.petals.engine.sampleclient.gui.Console;
import org.ow2.petals.jaas.GroupPrincipal;
import org.ow2.petals.jaas.UserPrincipal;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class SampleClient
implements Component,
ComponentLifeCycle {
    private ComponentContext context;
    private DeliveryChannel channel;
    private ServiceEndpoint endpointReference;
    private SampleClientListener listener;
    private Console console;
    private Logger logger;
    public static final String INONLY = "InOnly";
    public static final String INOUT = "InOut";
    public static final String INOPTIONALOUT = "InOptionalOut";
    public static final String ROBUSTINONLY = "RobustInOnly";

    public void init(ComponentContext context) throws JBIException {
        this.context = context;
        this.logger = context.getLogger("", null);
        this.console = new Console(this);
        this.channel = this.context.getDeliveryChannel();
        this.listener = new SampleClientListener(this.channel, this.console, this.logger);
        this.logger.log(Level.INFO, "init");
    }

    public void start() throws JBIException {
        this.logger.log(Level.INFO, "start");
        Thread listenerThread = new Thread((Runnable)this.listener, this.context.getComponentName() + "-JBI listener thread");
        listenerThread.start();
        this.console.setVisible(true);
    }

    public void stop() throws JBIException {
        this.logger.log(Level.INFO, "stop");
        this.listener.stopProcessing();
        this.console.setVisible(false);
    }

    public void shutDown() throws JBIException {
        this.logger.log(Level.INFO, "shutDown");
        this.listener.stopProcessing();
        this.console = null;
        this.channel.close();
        this.channel = null;
    }

    public ComponentLifeCycle getLifeCycle() {
        return this;
    }

    public Document getServiceDescription(ServiceEndpoint arg0) {
        return null;
    }

    public ServiceUnitManager getServiceUnitManager() {
        return null;
    }

    public boolean isExchangeWithConsumerOkay(ServiceEndpoint arg0, MessageExchange arg1) {
        return false;
    }

    public boolean isExchangeWithProviderOkay(ServiceEndpoint arg0, MessageExchange arg1) {
        this.logger.log(Level.INFO, "SampleClient accept the exchange");
        return true;
    }

    public ServiceEndpoint resolveEndpointReference(DocumentFragment arg0) {
        return null;
    }

    public ObjectName getExtensionMBeanName() {
        return null;
    }

    public void send(String itf, String service, String op, String endpoint, String content, String type, List<File> attachmentFiles, String properties, long syncTime) {
        this.logger.log(Level.INFO, "SampleClient try to send");
        try {
            Source source = Utils.createSource(content);
            InOnly msg = null;
            if (type.equals(INONLY)) {
                msg = this.channel.createExchangeFactory().createInOnlyExchange();
            } else if (type.equals(INOUT)) {
                msg = this.channel.createExchangeFactory().createInOutExchange();
            } else if (type.equals(INOPTIONALOUT)) {
                msg = this.channel.createExchangeFactory().createInOptionalOutExchange();
            } else if (type.equals(ROBUSTINONLY)) {
                msg = this.channel.createExchangeFactory().createRobustInOnlyExchange();
            }
            NormalizedMessage nm = msg.createMessage();
            nm.setContent(source);
            HashMap<String, String> map = null;
            if (properties != null) {
                map = new HashMap<String, String>();
                StringTokenizer tk = new StringTokenizer(properties, ";");
                while (tk.hasMoreTokens()) {
                    StringTokenizer tk2 = new StringTokenizer(tk.nextToken(), "=");
                    String key = tk2.nextToken().trim();
                    String value = tk2.nextToken().trim();
                    msg.setProperty(key, (Object)value);
                    nm.setProperty(key, (Object)value);
                    map.put(key, value);
                }
            }
            if (map != null) {
                String user = (String)map.get("sec.user");
                String group = (String)map.get("sec.group");
                if (user != null) {
                    Subject subject = new Subject();
                    Set<Principal> principals = subject.getPrincipals();
                    UserPrincipal up = new UserPrincipal(user);
                    principals.add((Principal)up);
                    GroupPrincipal gp = null;
                    gp = group != null ? new GroupPrincipal(group) : GroupPrincipal.ALL;
                    principals.add((Principal)gp);
                    nm.setSecuritySubject(subject);
                }
                String wsaTo = (String)map.get("wsa.to");
                HashMap<String, DocumentFragment> headers = new HashMap<String, DocumentFragment>(1);
                if (wsaTo != null) {
                    DocumentFragment frag = this.createWSAToDocFrag(wsaTo);
                    headers.put(Constants.TO_QNAME.toString(), frag);
                }
                nm.setProperty("javax.jbi.messaging.protocol.headers", headers);
            }
            if (attachmentFiles != null) {
                for (File attachmentFile : attachmentFiles) {
                    try {
                        nm.addAttachment(attachmentFile.getName(), new DataHandler((DataSource)new FileDataSource(attachmentFile)));
                    }
                    catch (MessagingException e) {
                        throw new Exception("Error when attaching file " + attachmentFile.getName());
                    }
                }
            }
            if (!Utils.isNullOrEmpty(endpoint)) {
                ServiceEndpoint svcEndpoint = this.context.getEndpoint(QName.valueOf(service), endpoint);
                if (svcEndpoint == null) {
                    throw new Exception("The endpoint '" + endpoint + "' for service '" + service + "' is not registered.");
                }
                msg.setEndpoint(svcEndpoint);
                msg.setEndpoint(svcEndpoint);
            }
            if (!Utils.isNullOrEmpty(service)) {
                msg.setService(QName.valueOf(service));
            }
            if (!Utils.isNullOrEmpty(itf)) {
                msg.setInterfaceName(QName.valueOf(itf));
            }
            msg.setOperation(QName.valueOf(op));
            if (type.equals(INONLY)) {
                msg.setInMessage(nm);
            } else if (type.equals(INOUT)) {
                ((InOut)msg).setInMessage(nm);
            } else if (type.equals(INOPTIONALOUT)) {
                ((InOptionalOut)msg).setInMessage(nm);
            } else if (type.equals(ROBUSTINONLY)) {
                ((RobustInOnly)msg).setInMessage(nm);
            }
            if (syncTime < 0L) {
                this.channel.send((MessageExchange)msg);
            } else {
                boolean ok = this.channel.sendSync((MessageExchange)msg, syncTime);
                if (ok) {
                    this.listener.process((MessageExchange)msg);
                } else {
                    this.console.setResponse("Time out !");
                }
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getMessage());
            this.console.setResponse(e.getMessage());
            this.console.showError(e);
        }
    }

    public ServiceEndpoint[] getEndpoints() {
        return this.context.getEndpoints(null);
    }

    public ServiceEndpoint resolveDescription(String text) {
        InputSource source = this.createSource(text);
        DocumentFragment result = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(source);
            result = document.createDocumentFragment();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.context.resolveEndpointReference(result);
    }

    public String getDescription(ServiceEndpoint se) {
        try {
            Document doc = this.context.getEndpointDescriptor(se);
            if (doc == null) {
                return null;
            }
            return XMLHelper.createStringFromDOMDocument((Node)doc);
        }
        catch (Throwable e) {
            this.console.showError(e);
            return null;
        }
    }

    public String getInterfaces(ServiceEndpoint se) {
        String out = "";
        try {
            for (QName interfaces : se.getInterfaces()) {
                out = out + interfaces;
            }
            return out;
        }
        catch (Throwable e) {
            this.console.showError(e);
            return null;
        }
    }

    public String getAsReference(ServiceEndpoint se) {
        try {
            DocumentFragment doc = se.getAsReference(null);
            if (doc == null) {
                return null;
            }
            return XMLHelper.createStringFromDOMDocument((Node)doc);
        }
        catch (Throwable e) {
            this.console.showError(e);
            return null;
        }
    }

    protected InputSource createSource(String msg) {
        InputSource source = new InputSource();
        byte[] msgByte = msg.getBytes();
        ByteArrayInputStream in = new ByteArrayInputStream(msgByte);
        source.setByteStream(in);
        return source;
    }

    protected DocumentFragment createWSAToDocFrag(String wsaToValue) {
        QName documentName = Constants.TO_QNAME;
        DocumentFragment result = null;
        Document doc = JVMDocumentBuilders.newDocument();
        Element elt = doc.createElementNS(documentName.getNamespaceURI(), documentName.getLocalPart());
        elt.setPrefix(documentName.getPrefix());
        result = doc.createDocumentFragment();
        result.appendChild(doc.importNode(elt, true));
        result.getFirstChild().setTextContent(wsaToValue);
        result.normalize();
        return result;
    }
}

